/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.celery.common.mq.config;

import cool.doudou.celery.common.mq.processor.consumer.ConsumerBeanPostProcessor;
import cool.doudou.celery.common.mq.processor.producer.ProducerBeanPostProcessor;
import cool.doudou.celery.common.mq.properties.PulsarProperties;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

public class PulsarConfig {
    private static final Logger log = LoggerFactory.getLogger(PulsarConfig.class);
    private PulsarProperties pulsarProperties;

    @Bean
    public PulsarClient pulsarClient() {
        try {
            return PulsarClient.builder().serviceUrl(this.pulsarProperties.getServiceUrl()).build();
        }
        catch (PulsarClientException e) {
            log.error("pulsarClient exception: ", (Throwable)e);
            return null;
        }
    }

    @DependsOn(value={"pulsarClient"})
    @Bean
    public ProducerBeanPostProcessor pulsarProducerBeanPostProcessor(PulsarClient pulsarClient) {
        return new ProducerBeanPostProcessor(pulsarClient, this.pulsarProperties);
    }

    @DependsOn(value={"pulsarClient"})
    @Bean
    public ConsumerBeanPostProcessor pulsarConsumerBeanPostProcessor(PulsarClient pulsarClient) {
        return new ConsumerBeanPostProcessor(pulsarClient, this.pulsarProperties);
    }

    public PulsarConfig(PulsarProperties pulsarProperties) {
        this.pulsarProperties = pulsarProperties;
    }
}

