/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.util;

import cool.doudou.doudada.cipher.algorithm.sm.Sm4Context;
import java.nio.charset.StandardCharsets;

public class Sm4Util {
    public static String encrypt(String plaintext, String encryptKey) {
        Sm4Context sm4Context = new Sm4Context();
        byte[] bytes = sm4Context.encryptByECB(Sm4Util.hexToByte(plaintext), encryptKey.getBytes(StandardCharsets.UTF_8));
        return Sm4Util.byteToHex(bytes);
    }

    public static String decrypt(String ciphertext, String decryptKey) {
        Sm4Context sm4Context = new Sm4Context();
        byte[] bytes = sm4Context.decryptByECB(Sm4Util.hexToByte(ciphertext), decryptKey.getBytes(StandardCharsets.UTF_8));
        return new String(bytes);
    }

    public static String encrypt(String plaintext, String encryptKey, String iv) {
        Sm4Context sm4Context = new Sm4Context();
        byte[] bytes = sm4Context.encryptByCBC(Sm4Util.hexToByte(plaintext), encryptKey.getBytes(StandardCharsets.UTF_8), iv.getBytes(StandardCharsets.UTF_8));
        return Sm4Util.byteToHex(bytes);
    }

    public static String decrypt(String ciphertext, String decryptKey, String iv) {
        Sm4Context sm4Context = new Sm4Context();
        byte[] bytes = sm4Context.decryptByCBC(Sm4Util.hexToByte(ciphertext), decryptKey.getBytes(StandardCharsets.UTF_8), iv.getBytes(StandardCharsets.UTF_8));
        return new String(bytes);
    }

    private static String byteToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            Object hex = Integer.toHexString(b & 0xFF);
            if (((String)hex).length() < 2) {
                hex = "0" + (String)hex;
            }
            sb.append((String)hex);
        }
        return sb.toString();
    }

    private static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (hex.length() < 1) {
            return null;
        }
        byte[] result = new byte[hex.length() / 2];
        int j = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            result[j++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return result;
    }
}

