/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.util;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class Sm3Util {
    public static String hash(String plaintext) {
        return ByteUtils.toHexString((byte[])Sm3Util.hash(plaintext.getBytes(StandardCharsets.UTF_8)));
    }

    public static String hmac(String plaintext, String encryptKey) {
        return ByteUtils.toHexString((byte[])Sm3Util.hmac(plaintext.getBytes(StandardCharsets.UTF_8), encryptKey.getBytes(StandardCharsets.UTF_8)));
    }

    private static byte[] hash(byte[] srcData) {
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    private static byte[] hmac(byte[] key, byte[] srcData) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(srcData, 0, srcData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

