/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.util;

import cool.doudou.doudada.cipher.algorithm.enums.SignAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class SignatureUtil {
    public static byte[] sign(SignAlgorithm signAlgorithm, String plaintext, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(signAlgorithm.name());
            signature.initSign(privateKey);
            signature.update(plaintext.getBytes(StandardCharsets.UTF_8));
            return signature.sign();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(SignAlgorithm signAlgorithm, String ciphertext, PublicKey publicKey, String signatureStr) {
        try {
            Signature signature = Signature.getInstance(signAlgorithm.name());
            signature.initVerify(publicKey);
            signature.update(ciphertext.getBytes(StandardCharsets.UTF_8));
            return signature.verify(signatureStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

