/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.sm;

import cool.doudou.doudada.cipher.algorithm.sm.Sm2;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class Cipher {
    private int ct = 1;
    private ECPoint ecPoint;
    private SM3Digest sm3DigestP2;
    private SM3Digest sm3DigestC3;
    private final byte[] key = new byte[32];
    private byte keyOff = 0;

    private void reset() {
        this.sm3DigestP2 = new SM3Digest();
        this.sm3DigestC3 = new SM3Digest();
        byte[] xBytes = Cipher.byteConvert32Bytes(this.ecPoint.getX().toBigInteger());
        this.sm3DigestP2.update(xBytes, 0, xBytes.length);
        this.sm3DigestC3.update(xBytes, 0, xBytes.length);
        byte[] yBytes = Cipher.byteConvert32Bytes(this.ecPoint.getY().toBigInteger());
        this.sm3DigestP2.update(yBytes, 0, yBytes.length);
        this.ct = 1;
        this.nextKey();
    }

    private void nextKey() {
        SM3Digest sm3Digest = new SM3Digest(this.sm3DigestP2);
        sm3Digest.update((byte)(this.ct >> 24 & 0xFF));
        sm3Digest.update((byte)(this.ct >> 16 & 0xFF));
        sm3Digest.update((byte)(this.ct >> 8 & 0xFF));
        sm3Digest.update((byte)(this.ct & 0xFF));
        sm3Digest.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    public ECPoint initEnc(Sm2 sm2, ECPoint userKey) {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = sm2.eccKeyPairGenerator.generateKeyPair();
        ECPrivateKeyParameters ecPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        ECPublicKeyParameters ecPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        BigInteger d = ecPrivateKeyParameters.getD();
        ECPoint q = ecPublicKeyParameters.getQ();
        this.ecPoint = userKey.multiply(d);
        this.reset();
        return q;
    }

    public void encrypt(byte[] data) {
        this.sm3DigestC3.update(data, 0, data.length);
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
    }

    public void initDec(BigInteger userD, ECPoint ecPointC1) {
        this.ecPoint = ecPointC1.multiply(userD);
        this.reset();
    }

    public void decrypt(byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
        this.sm3DigestC3.update(data, 0, data.length);
    }

    public void doFinal(byte[] outBytes) {
        byte[] yBytes = Cipher.byteConvert32Bytes(this.ecPoint.getY().toBigInteger());
        this.sm3DigestC3.update(yBytes, 0, yBytes.length);
        this.sm3DigestC3.doFinal(outBytes, 0);
        this.reset();
    }

    private static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] bytes;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            bytes = new byte[32];
            System.arraycopy(n.toByteArray(), 1, bytes, 0, 32);
        } else if (n.toByteArray().length == 32) {
            bytes = n.toByteArray();
        } else {
            bytes = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                bytes[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, bytes, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return bytes;
    }
}

