/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.util;

import cool.doudou.doudada.cipher.algorithm.sm.Cipher;
import cool.doudou.doudada.cipher.algorithm.sm.Sm2;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.springframework.util.ObjectUtils;

public class Sm2Util {
    public static String encrypt(String publicKey, String plaintext) {
        if (ObjectUtils.isEmpty((Object)publicKey)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)plaintext)) {
            return null;
        }
        byte[] plaintextBytes = plaintext.getBytes(StandardCharsets.UTF_8);
        byte[] source = new byte[plaintextBytes.length];
        System.arraycopy(plaintextBytes, 0, source, 0, plaintextBytes.length);
        Cipher cipher = new Cipher();
        Sm2 sm2 = Sm2.Instance();
        ECPoint userKey = sm2.eccCurve.decodePoint(Sm2Util.hexToByte(publicKey));
        ECPoint ecPointC1 = cipher.initEnc(sm2, userKey);
        cipher.encrypt(source);
        byte[] outBytes = new byte[32];
        cipher.doFinal(outBytes);
        return Sm2Util.byteToHex(ecPointC1.getEncoded(false)) + Sm2Util.byteToHex(outBytes) + Sm2Util.byteToHex(source);
    }

    public static String decrypt(String privateKey, String ciphertext) {
        if (ObjectUtils.isEmpty((Object)privateKey)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)ciphertext)) {
            return null;
        }
        byte[] privateKeyBytes = Sm2Util.hexToByte(privateKey);
        if (privateKeyBytes == null) {
            return null;
        }
        byte[] ciphertextBytes = Sm2Util.hexToByte(ciphertext);
        if (ciphertextBytes == null) {
            return null;
        }
        byte[] c1Bytes = Sm2Util.hexToByte(ciphertext.substring(0, 130));
        byte[] c3 = Sm2Util.hexToByte(ciphertext.substring(130, 194));
        byte[] c2 = Sm2Util.hexToByte(ciphertext.substring(194, 194 + 2 * (ciphertextBytes.length - 97)));
        if (c2 == null) {
            return null;
        }
        Sm2 sm2 = Sm2.Instance();
        BigInteger userD = new BigInteger(1, privateKeyBytes);
        ECPoint ecPointC1 = sm2.eccCurve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.initDec(userD, ecPointC1);
        cipher.decrypt(c2);
        cipher.doFinal(c3);
        return new String(c2);
    }

    public static Map<String, String> generateKeyPair() {
        AsymmetricCipherKeyPair key;
        Sm2 sm2 = Sm2.Instance();
        while (((ECPrivateKeyParameters)(key = sm2.eccKeyPairGenerator.generateKeyPair()).getPrivate()).getD().toByteArray().length != 32) {
        }
        ECPrivateKeyParameters ecPrivateKeyParameters = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecPublicKeyParameters = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecPrivateKeyParameters.getD();
        ECPoint publicKey = ecPublicKeyParameters.getQ();
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("publicKey", Sm2Util.byteToHex(publicKey.getEncoded()));
        result.put("privateKey", Sm2Util.byteToHex(privateKey.toByteArray()));
        return result;
    }

    private static String byteToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            Object hex = Integer.toHexString(b & 0xFF);
            if (((String)hex).length() < 2) {
                hex = "0" + (String)hex;
            }
            sb.append((String)hex);
        }
        return sb.toString();
    }

    private static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (hex.length() < 1) {
            return null;
        }
        byte[] result = new byte[hex.length() / 2];
        int j = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            result[j++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return result;
    }
}

