/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.util;

import cool.doudou.doudada.cipher.algorithm.enums.Algorithm;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RsaUtil {
    private static final String transformation = "RSA";

    public static String encrypt(String publicKey, String plaintext) throws Exception {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)KeyFactory.getInstance(Algorithm.RSA.code()).generatePublic(new X509EncodedKeySpec(publicKey.getBytes(StandardCharsets.UTF_8)));
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, rsaPublicKey);
        byte[] bytes = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String decrypt(String privateKey, String ciphertext) throws Exception {
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)KeyFactory.getInstance(Algorithm.RSA.code()).generatePrivate(new PKCS8EncodedKeySpec(privateKey.getBytes(StandardCharsets.UTF_8)));
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, rsaPrivateKey);
        byte[] bytes = cipher.doFinal(ciphertext.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static Map<String, String> generateKeyPair(int keySize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(Algorithm.RSA.code());
        keyPairGenerator.initialize(keySize, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("publicKey", new String(Base64.getEncoder().encode(keyPair.getPublic().getEncoded())));
        result.put("privateKey", new String(Base64.getEncoder().encode(keyPair.getPrivate().getEncoded())));
        return result;
    }
}

