/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.util;

import cool.doudou.doudada.cipher.algorithm.enums.Algorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.util.ObjectUtils;

public class AesUtil {
    private static final String transformationGCM = "AES/GCM/NoPadding";
    private static final String transformationCBC = "AES/CBC/NoPadding";

    public static String encryptGCM(String encryptKey, String iv, String plaintext, String salt) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey.getBytes(StandardCharsets.UTF_8), Algorithm.AES.code());
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance(transformationGCM);
        cipher.init(1, (Key)secretKeySpec, gcmParameterSpec);
        if (!ObjectUtils.isEmpty((Object)salt)) {
            cipher.updateAAD(salt.getBytes(StandardCharsets.UTF_8));
        }
        byte[] bytes = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String decryptGCM(String decryptKey, String iv, String ciphertext, String salt) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(decryptKey.getBytes(StandardCharsets.UTF_8), Algorithm.AES.code());
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance(transformationGCM);
        cipher.init(2, (Key)secretKeySpec, gcmParameterSpec);
        if (!ObjectUtils.isEmpty((Object)salt)) {
            cipher.updateAAD(salt.getBytes(StandardCharsets.UTF_8));
        }
        byte[] bytes = cipher.doFinal(Base64.getDecoder().decode(ciphertext));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String encryptCBC4Hex(String encryptKey, String iv, String plaintext, String salt) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey.getBytes(StandardCharsets.UTF_8), Algorithm.AES.code());
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
        Cipher cipher = Cipher.getInstance(transformationCBC);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        if (!ObjectUtils.isEmpty((Object)salt)) {
            cipher.updateAAD(salt.getBytes(StandardCharsets.UTF_8));
        }
        StringBuilder sbPlaintext = new StringBuilder(plaintext);
        while (sbPlaintext.toString().getBytes(StandardCharsets.UTF_8).length % 16 != 0) {
            sbPlaintext.append(" ");
        }
        plaintext = sbPlaintext.toString();
        byte[] bytes = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
        return Hex.toHexString((byte[])bytes);
    }

    public static String decryptCBC4Hex(String decryptKey, String iv, String ciphertext, String salt) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(decryptKey.getBytes(StandardCharsets.US_ASCII), Algorithm.AES.code());
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
        Cipher cipher = Cipher.getInstance(transformationCBC);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        if (!ObjectUtils.isEmpty((Object)salt)) {
            cipher.updateAAD(salt.getBytes(StandardCharsets.UTF_8));
        }
        byte[] bytes = cipher.doFinal(Hex.decode((String)ciphertext));
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

