/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.sm;

import cool.doudou.doudada.cipher.algorithm.sm.Sm4;

public class Sm4Context {
    public int mode = 1;
    public long[] sk = new long[32];
    public boolean isPadding = true;

    public byte[] encryptByECB(byte[] plainTextBytes, byte[] keyBytes) {
        if (keyBytes != null && keyBytes.length == 16) {
            if (plainTextBytes != null && plainTextBytes.length > 0) {
                try {
                    Sm4Context ctx = new Sm4Context();
                    ctx.isPadding = true;
                    ctx.mode = 1;
                    Sm4 sm4 = new Sm4();
                    sm4.sm4SetKeyEnc(ctx, keyBytes);
                    return sm4.sm4CryptEcb(ctx, plainTextBytes);
                }
                catch (Exception var6) {
                    var6.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public byte[] decryptByECB(byte[] cipherTextBytes, byte[] keyBytes) {
        if (keyBytes != null && keyBytes.length == 16) {
            if (cipherTextBytes != null && cipherTextBytes.length > 0 && cipherTextBytes.length % 16 == 0) {
                try {
                    Sm4Context ctx = new Sm4Context();
                    ctx.isPadding = true;
                    ctx.mode = 0;
                    Sm4 sm4 = new Sm4();
                    sm4.sm4SetKeyDec(ctx, keyBytes);
                    byte[] decrypted = sm4.sm4CryptEcb(ctx, cipherTextBytes);
                    int decryptedLen = decrypted.length;
                    int i = decrypted.length - 1;
                    while (i >= 0 && decrypted[i] == 0) {
                        --i;
                        --decryptedLen;
                    }
                    byte[] temp = new byte[decryptedLen];
                    System.arraycopy(decrypted, 0, temp, 0, decryptedLen);
                    return temp;
                }
                catch (Exception var8) {
                    var8.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public byte[] encryptByCBC(byte[] plainTextBytes, byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes != null && keyBytes.length != 0 && keyBytes.length % 16 == 0) {
            if (plainTextBytes != null && plainTextBytes.length > 0) {
                if (ivBytes != null && ivBytes.length > 0) {
                    try {
                        Sm4Context ctx = new Sm4Context();
                        ctx.isPadding = true;
                        ctx.mode = 1;
                        Sm4 sm4 = new Sm4();
                        sm4.sm4SetKeyEnc(ctx, keyBytes);
                        return sm4.sm4CryptCbc(ctx, ivBytes, plainTextBytes);
                    }
                    catch (Exception var7) {
                        var7.printStackTrace();
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public byte[] decryptByCBC(byte[] cipherTextBytes, byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes != null && keyBytes.length != 0 && keyBytes.length % 16 == 0) {
            if (cipherTextBytes != null && cipherTextBytes.length > 0) {
                if (ivBytes != null && ivBytes.length > 0) {
                    try {
                        Sm4Context ctx = new Sm4Context();
                        ctx.isPadding = true;
                        ctx.mode = 0;
                        Sm4 sm4 = new Sm4();
                        sm4.sm4SetKeyDec(ctx, keyBytes);
                        return sm4.sm4CryptCbc(ctx, ivBytes, cipherTextBytes);
                    }
                    catch (Exception var7) {
                        var7.printStackTrace();
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

