/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.sm;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class Sm2 {
    public static String[] eccParam = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public final BigInteger eccP = new BigInteger(eccParam[0], 16);
    public final BigInteger eccA = new BigInteger(eccParam[1], 16);
    public final BigInteger eccB = new BigInteger(eccParam[2], 16);
    public final BigInteger eccN = new BigInteger(eccParam[3], 16);
    public final BigInteger eccGx = new BigInteger(eccParam[4], 16);
    public final BigInteger eccGy = new BigInteger(eccParam[5], 16);
    public final ECCurve eccCurve;
    public final ECPoint eccPointG;
    public final ECDomainParameters eccBcSpec;
    public final ECKeyPairGenerator eccKeyPairGenerator;
    public final ECFieldElement ecFieldElementGx = new ECFieldElement.Fp(this.eccP, this.eccGx);
    public final ECFieldElement ecFieldElementGy = new ECFieldElement.Fp(this.eccP, this.eccGy);

    public static Sm2 Instance() {
        return new Sm2();
    }

    public Sm2() {
        this.eccCurve = new ECCurve.Fp(this.eccP, this.eccA, this.eccB);
        this.eccPointG = new ECPoint.Fp(this.eccCurve, this.ecFieldElementGx, this.ecFieldElementGy);
        this.eccBcSpec = new ECDomainParameters(this.eccCurve, this.eccPointG, this.eccN);
        ECKeyGenerationParameters ecKeyGenerationParameters = new ECKeyGenerationParameters(this.eccBcSpec, new SecureRandom());
        this.eccKeyPairGenerator = new ECKeyPairGenerator();
        this.eccKeyPairGenerator.init((KeyGenerationParameters)ecKeyGenerationParameters);
    }
}

