package cool.doudou.doudada.cipher.algorithm.util;

import cool.doudou.doudada.cipher.algorithm.enums.Algorithm;
import org.springframework.util.ObjectUtils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

/**
 * 摘要算法
 *
 * @author jiangcs
 * @since 2022/08/25
 */
public class DigestUtil {
    /**
     * MD5
     *
     * @param plaintext 明文
     * @param salt      盐
     * @return 加密字节数组
     * @throws Exception 加密异常
     */
    public static byte[] md5(String plaintext, String salt) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.MD5.code());
        if (!ObjectUtils.isEmpty(salt)) {
            plaintext += salt;
        }
        messageDigest.update(plaintext.getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }

    /**
     * MD5
     *
     * @param plaintext 明文
     * @param salt      盐
     * @return 加密Hex字符串
     * @throws Exception 加密异常
     */
    public static String md5Hex(String plaintext, String salt) throws Exception {
        byte[] bytes = md5(plaintext, salt);
        StringBuilder sbHex = new StringBuilder();
        for (byte b : bytes) {
            String bHex = Integer.toHexString(b & 0xFF);
            if (bHex.length() < 2) {
                sbHex.append(0);
            }
            sbHex.append(bHex);
        }
        return sbHex.toString();
    }

    /**
     * SHA1
     *
     * @param plaintext 明文
     * @param salt      盐
     * @return 加密字节数组
     * @throws Exception 加密异常
     */
    public static byte[] sha1(String plaintext, String salt) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SHA1.code());
        if (!ObjectUtils.isEmpty(salt)) {
            plaintext += salt;
        }
        messageDigest.update(plaintext.getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }

    /**
     * SHA1
     *
     * @param plaintext 明文
     * @param salt      盐
     * @return 加密Hex字符串
     * @throws Exception 加密异常
     */
    public static String sha1Hex(String plaintext, String salt) throws Exception {
        byte[] bytes = sha1(plaintext, salt);
        StringBuilder sbHex = new StringBuilder();
        for (byte b : bytes) {
            String bHex = Integer.toHexString(b & 0xFF);
            if (bHex.length() < 2) {
                sbHex.append(0);
            }
            sbHex.append(bHex);
        }
        return sbHex.toString();
    }

    /**
     * SHA256
     *
     * @param plaintext 明文
     * @param salt      盐
     * @return 加密字节数组
     * @throws Exception 加密异常
     */
    public static byte[] sha256(String plaintext, String salt) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SHA256.code());
        if (!ObjectUtils.isEmpty(salt)) {
            plaintext += salt;
        }
        messageDigest.update(plaintext.getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }

    /**
     * SHA256
     *
     * @param plaintext 明文
     * @param salt      盐
     * @return 加密Hex字符串
     * @throws Exception 加密异常
     */
    public static String sha256Hex(String plaintext, String salt) throws Exception {
        byte[] bytes = sha256(plaintext, salt);
        StringBuilder sbHex = new StringBuilder();
        for (byte b : bytes) {
            String bHex = Integer.toHexString(b & 0xFF);
            if (bHex.length() < 2) {
                sbHex.append(0);
            }
            sbHex.append(bHex);
        }
        return sbHex.toString();
    }
}
