package cool.doudou.doudada.cipher.algorithm.sm;

/**
 * Sm4Context
 *
 * @author jiangcs
 * @since 2022/08/31
 */
public class Sm4Context {
    public int mode = 1;
    public long[] sk = new long[32];
    public boolean isPadding = true;

    public Sm4Context() {
    }

    /**
     * ECB加密
     *
     * @param plainTextBytes 明文字节数组
     * @param keyBytes       key字节数组
     * @return 加密字节数组
     */
    public byte[] encryptByECB(byte[] plainTextBytes, byte[] keyBytes) {
        if (keyBytes != null && keyBytes.length == 16) {
            if (plainTextBytes != null && plainTextBytes.length > 0) {
                try {
                    Sm4Context ctx = new Sm4Context();
                    ctx.isPadding = true;
                    ctx.mode = 1;
                    Sm4 sm4 = new Sm4();
                    sm4.sm4SetKeyEnc(ctx, keyBytes);
                    return sm4.sm4CryptEcb(ctx, plainTextBytes);
                } catch (Exception var6) {
                    var6.printStackTrace();
                    return null;
                }
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    /**
     * ECB解密
     *
     * @param cipherTextBytes 密文字节数组
     * @param keyBytes        key字节数组
     * @return 解密字节数组
     */
    public byte[] decryptByECB(byte[] cipherTextBytes, byte[] keyBytes) {
        if (keyBytes != null && keyBytes.length == 16) {
            if (cipherTextBytes != null && cipherTextBytes.length > 0 && cipherTextBytes.length % 16 == 0) {
                try {
                    Sm4Context ctx = new Sm4Context();
                    ctx.isPadding = true;
                    ctx.mode = 0;
                    Sm4 sm4 = new Sm4();
                    sm4.sm4SetKeyDec(ctx, keyBytes);
                    byte[] decrypted = sm4.sm4CryptEcb(ctx, cipherTextBytes);
                    int decryptedLen = decrypted.length;

                    for (int i = decrypted.length - 1; i >= 0 && decrypted[i] == 0; --decryptedLen) {
                        --i;
                    }

                    byte[] temp = new byte[decryptedLen];
                    System.arraycopy(decrypted, 0, temp, 0, decryptedLen);
                    return temp;
                } catch (Exception var8) {
                    var8.printStackTrace();
                    return null;
                }
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    /**
     * CBC加密
     *
     * @param plainTextBytes 明文字节数组
     * @param keyBytes       key字节数组
     * @param ivBytes        初始化向量字节数组
     * @return 加密字节数组
     */
    public byte[] encryptByCBC(byte[] plainTextBytes, byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes != null && keyBytes.length != 0 && keyBytes.length % 16 == 0) {
            if (plainTextBytes != null && plainTextBytes.length > 0) {
                if (ivBytes != null && ivBytes.length > 0) {
                    try {
                        Sm4Context ctx = new Sm4Context();
                        ctx.isPadding = true;
                        ctx.mode = 1;
                        Sm4 sm4 = new Sm4();
                        sm4.sm4SetKeyEnc(ctx, keyBytes);
                        return sm4.sm4CryptCbc(ctx, ivBytes, plainTextBytes);
                    } catch (Exception var7) {
                        var7.printStackTrace();
                        return null;
                    }
                } else {
                    return null;
                }
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    /**
     * CBC解密
     *
     * @param cipherTextBytes 密文字节数组
     * @param keyBytes        key字节数组
     * @param ivBytes         初始化向量字节数组
     * @return 解密字节数组
     */
    public byte[] decryptByCBC(byte[] cipherTextBytes, byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes != null && keyBytes.length != 0 && keyBytes.length % 16 == 0) {
            if (cipherTextBytes != null && cipherTextBytes.length > 0) {
                if (ivBytes != null && ivBytes.length > 0) {
                    try {
                        Sm4Context ctx = new Sm4Context();
                        ctx.isPadding = true;
                        ctx.mode = 0;
                        Sm4 sm4 = new Sm4();
                        sm4.sm4SetKeyDec(ctx, keyBytes);
                        return sm4.sm4CryptCbc(ctx, ivBytes, cipherTextBytes);
                    } catch (Exception var7) {
                        var7.printStackTrace();
                        return null;
                    }
                } else {
                    return null;
                }
            } else {
                return null;
            }
        } else {
            return null;
        }
    }
}
