/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.hibernate;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.cfg.Configuration;
import org.apache.beehive.controls.api.bean.ControlImplementation;
import org.apache.beehive.controls.api.context.Context;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.context.ResourceContext;
import org.apache.beehive.controls.api.events.EventHandler;
import org.apache.log4j.Logger;
import org.controlhaus.hibernate.HibernateControl;
import org.controlhaus.hibernate.HibernateFactory;

@ControlImplementation
public class HibernateControlImpl
implements HibernateControl {
    private static Logger logger = Logger.getLogger((String)HibernateControlImpl.class.getName());
    private ThreadLocal<Session> session = new ThreadLocal();
    private ThreadLocal<Transaction> transactions = new ThreadLocal();
    private SessionFactory sessionFactory;
    private Configuration hibConfig;
    private boolean manageTXs = false;
    @Context
    ControlBeanContext context;
    @Context
    ResourceContext resourceContext;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Configuration getConfiguration() {
        return this.hibConfig;
    }

    @EventHandler(field="context", eventSet=ControlBeanContext.LifeCycle.class, eventName="onCreate")
    public void onCreate() {
        HibernateControl.ManagedTransactions txProp = (HibernateControl.ManagedTransactions)this.context.getControlPropertySet(HibernateControl.ManagedTransactions.class);
        if (txProp != null) {
            this.manageTXs = txProp.value();
        }
        this.sessionFactory = HibernateFactory.getInstance().getSessionFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(field="resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onRelease")
    public void onRelease() {
        block8: {
            try {
                logger.debug((Object)"Closing open hibernate session.");
                if (this.manageTXs) {
                    Transaction t = this.getTransaction();
                    if (t == null) break block8;
                    try {
                        t.commit();
                        break block8;
                    }
                    catch (HibernateException e) {
                        t.rollback();
                        break block8;
                    }
                    finally {
                        this.closeSession();
                    }
                }
                this.closeSession();
            }
            catch (HibernateException e) {
                logger.error((Object)"Couldn't close session!", (Throwable)e);
            }
        }
    }

    public Session getSession() throws HibernateException {
        Session s = this.session.get();
        if (s == null) {
            s = this.sessionFactory.openSession();
            this.session.set(s);
            if (this.manageTXs) {
                this.transactions.set(s.beginTransaction());
            }
        }
        return s;
    }

    public Transaction getTransaction() {
        return this.transactions.get();
    }

    public void closeSession() throws HibernateException {
        Session s;
        logger.info((Object)"Closing session for thread.");
        if (this.manageTXs) {
            this.transactions.remove();
        }
        if ((s = this.session.get()) != null) {
            this.session.remove();
            s.close();
        }
    }
}

