/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.el.util;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.beehive.netui.script.el.ExpressionParseException;
import org.apache.beehive.netui.script.el.NetUIVariableResolver;
import org.apache.beehive.netui.script.el.ParsedExpression;
import org.apache.beehive.netui.script.el.parser.NetUIELParser;
import org.apache.beehive.netui.script.el.parser.ParseException;
import org.apache.beehive.netui.script.el.parser.TokenMgrError;
import org.apache.beehive.netui.util.cache.PropertyCache;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.beehive.netui.util.type.TypeUtils;

public class ParseUtils {
    private static final Logger _logger = Logger.getInstance(ParseUtils.class);
    private static final HashMap<String, ParsedExpression> PARSED_CACHE = new HashMap();

    private ParseUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ParsedExpression parse(String exprStr) {
        ParsedExpression pe = PARSED_CACHE.get(exprStr);
        if (pe != null) {
            return pe;
        }
        try {
            NetUIELParser learn = new NetUIELParser(new StringReader(exprStr));
            ParsedExpression expr = learn.parse();
            expr.seal();
            HashMap<String, ParsedExpression> hashMap = PARSED_CACHE;
            synchronized (hashMap) {
                PARSED_CACHE.put(exprStr, expr);
            }
            return expr;
        }
        catch (ParseException e) {
            String msg = "Error occurred parsing expression \"" + exprStr + "\".";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new ExpressionParseException(msg, e);
        }
        catch (TokenMgrError tm) {
            String msg = "Error occurred parsing expression \"" + exprStr + "\".";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)tm);
            }
            throw new ExpressionParseException(msg, tm);
        }
    }

    public static final Object evaluate(String exprStr, NetUIVariableResolver vr) {
        ParsedExpression expr = ParseUtils.parse(exprStr);
        assert (expr != null);
        return expr.evaluate(vr);
    }

    public static final void update(String exprStr, Object value, NetUIVariableResolver vr) {
        ParsedExpression expr = ParseUtils.parse(exprStr);
        assert (expr != null);
        expr.update(value, vr);
    }

    public static final Class getPropertyType(Object value, String name, PropertyCache cache) {
        assert (value != null);
        assert (cache != null);
        Class<?> type = value.getClass();
        Field f = cache.getField(type, name);
        if (f != null) {
            return f.getType();
        }
        Method m = cache.getPropertySetter(type, name);
        if (m == null) {
            String msg = "Can not find setter method for property \"" + name + "\" on object of type \"" + value.getClass() + "\".";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        assert (m.getParameterTypes().length == 1);
        return m.getParameterTypes()[0];
    }

    public static final Object getProperty(Object value, String name, PropertyCache cache) {
        assert (value != null);
        assert (cache != null);
        Class<?> type = value.getClass();
        Field f = cache.getField(type, name);
        if (f != null) {
            try {
                return f.get(value);
            }
            catch (Exception e) {
                String msg = "An error occurred evaluating the field \"" + name + "\" on an object of type \"" + type + "\".";
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        Method m = cache.getPropertyGetter(type, name);
        if (m != null) {
            try {
                return m.invoke(value, (Object[])null);
            }
            catch (Exception e) {
                String msg = "An error occurred invoking a getter for the property  \"" + name + "\" on an object of type \"" + type + "\".";
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        String msg = "Could not find property or field \"" + name + "\" on object of type \"" + type + "\"";
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)msg);
        }
        throw new RuntimeException(msg);
    }

    public static final Object convertType(Object value, Class toType) {
        assert (toType != null);
        try {
            boolean sourceIsArray = false;
            if (value != null && !(value instanceof String) && !(sourceIsArray = value instanceof String[])) {
                return value;
            }
            if (toType.isArray()) {
                if (value == null) {
                    return null;
                }
                Class<?> compType = toType.getComponentType();
                String[] strs = null;
                strs = value.getClass().isArray() ? (String[])value : new String[]{(String)value};
                Object tgt = Array.newInstance(compType, strs.length);
                for (int i = 0; i < strs.length; ++i) {
                    Object o = null;
                    try {
                        o = TypeUtils.convertToObject((String)strs[i], compType);
                    }
                    catch (IllegalArgumentException e) {
                        String msg = "Can not set Object types via expressions that are not supported by the set of registered type converters.  Cause: " + e;
                        if (_logger.isErrorEnabled()) {
                            _logger.error((Object)msg, (Throwable)e);
                        }
                        throw new RuntimeException(msg, e);
                    }
                    Array.set(tgt, i, o);
                }
                return tgt;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("convert value \"" + value + "\" to type: " + toType));
            }
            if (sourceIsArray) {
                assert (value instanceof String[]);
                assert (Array.getLength(value) > 0 && Array.getLength(value) - 1 >= 0);
                value = Array.get(value, Array.getLength(value) - 1);
            }
            try {
                assert (value == null || value instanceof String);
                return TypeUtils.convertToObject((String)((String)value), (Class)toType);
            }
            catch (IllegalArgumentException e) {
                String msg = "The type \"" + toType.getName() + "\" can not be set through XScript with the update value \"" + value + "\"";
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        catch (Exception e) {
            String msg = "Unable to convert a value of type \"" + value.getClass() + "\" to the array element type of \"" + toType + "\".  Cause: " + e;
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new RuntimeException(msg, e);
        }
    }

    public static String getContextString(String[] contexts) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (contexts != null) {
            for (int i = 0; i < contexts.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(contexts[i]);
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }
}

