/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.el;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.script.IllegalExpressionException;
import org.apache.beehive.netui.script.common.ImplicitObjectUtil;
import org.apache.beehive.netui.script.el.NetUIVariableResolver;
import org.apache.beehive.netui.script.el.util.RequestAttributeMap;
import org.apache.beehive.netui.script.el.util.SessionAttributeMap;
import org.apache.beehive.netui.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetUIUpdateVariableResolver
extends NetUIVariableResolver
implements VariableResolver {
    private static final Logger _logger = Logger.getInstance(NetUIVariableResolver.class);
    private boolean _requestParameter = true;
    private Object _form = null;
    private ServletRequest _request = null;
    private ServletResponse _response = null;

    public NetUIUpdateVariableResolver(Object form, ServletRequest request, ServletResponse response, boolean requestParameter) {
        this._requestParameter = requestParameter;
        this._form = form;
        this._request = request;
        this._response = response;
    }

    @Override
    public Object resolveVariable(String name) {
        if (name.equals("actionForm")) {
            return this._form;
        }
        if (name.equals("pageFlow")) {
            return NetUIUpdateVariableResolver.getPageFlow(this._request, this._response);
        }
        if (name.equals("globalApp")) {
            return NetUIUpdateVariableResolver.getGlobalApp(this._request, this._response);
        }
        if (name.equals("sharedFlow")) {
            return NetUIUpdateVariableResolver.getSharedFlow(this._request, this._response);
        }
        if (name.equals("requestScope")) {
            if (!this._requestParameter) {
                return new RequestAttributeMap(this._request);
            }
            throw new IllegalExpressionException("The request data binding context can not be updated from a request parameter.");
        }
        if (name.equals("sessionScope")) {
            if (!this._requestParameter) {
                return new SessionAttributeMap(((HttpServletRequest)this._request).getSession());
            }
            throw new IllegalExpressionException("The session data binding context can not be updated from a request parameter.");
        }
        if (name.equals("applicationScope")) {
            if (!this._requestParameter) {
                return null;
            }
            throw new IllegalExpressionException("The application data binding context can not be updated from a request parameter.");
        }
        String msg = "Could not resolve variable named \"" + name + "\" for an expression update.";
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)msg);
        }
        throw new IllegalExpressionException(msg);
    }

    @Override
    public String[] getAvailableVariables() {
        if (this._requestParameter) {
            return new String[]{"actionForm", "pageFlow", "globalApp"};
        }
        return new String[]{"actionForm", "pageFlow", "globalApp", "request", "session", "application"};
    }

    private static final Map<String, SharedFlowController> getSharedFlow(ServletRequest request, ServletResponse response) {
        return ImplicitObjectUtil.getSharedFlow(request);
    }

    private static final PageFlowController getPageFlow(ServletRequest request, ServletResponse response) {
        return ImplicitObjectUtil.getPageFlow(request, response);
    }

    private static final GlobalApp getGlobalApp(ServletRequest request, ServletResponse response) {
        return ImplicitObjectUtil.getGlobalApp(request, response);
    }
}

