/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.beehive.netui.script.Expression;
import org.apache.beehive.netui.script.el.NetUIVariableResolver;
import org.apache.beehive.netui.script.el.ParsedExpression;
import org.apache.beehive.netui.script.el.Term;
import org.apache.beehive.netui.script.el.tokens.ArrayIndexToken;
import org.apache.beehive.netui.script.el.tokens.ContextToken;
import org.apache.beehive.netui.script.el.tokens.ExpressionToken;
import org.apache.beehive.netui.script.el.tokens.IdentifierToken;
import org.apache.beehive.netui.script.el.tokens.MapKeyToken;
import org.apache.beehive.netui.script.el.util.BindingContext;
import org.apache.beehive.netui.script.el.util.ParseUtils;
import org.apache.beehive.netui.util.logging.Logger;

public class ExpressionTerm
extends Expression
implements Term {
    private static Logger _logger = Logger.getInstance(ExpressionTerm.class);
    private List tokens = new ArrayList();
    private String exprStr = null;
    private ContextToken context = null;
    private ExpressionToken[] tokenArray = null;
    private List _noModTokens = null;

    public void seal() {
        this.context = (ContextToken)this.tokens.get(0);
        this.tokenArray = new ExpressionToken[this.tokens.size()];
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.tokens.size(); ++i) {
            buf.append(((ExpressionToken)this.tokens.get(i)).getTokenString());
            this.tokenArray[i] = (ExpressionToken)this.tokens.get(i);
        }
        this.exprStr = buf.toString();
        this._noModTokens = Collections.unmodifiableList(this.tokens);
    }

    public String getContext() {
        return this.context.getName();
    }

    public List getTokens() {
        return this._noModTokens;
    }

    public String getExpression(int start) {
        if (start >= this.tokens.size()) {
            throw new IllegalStateException("The index \"" + start + "\" is an invalid reference into an expression with \"" + this.tokens.size() + "\" tokens.");
        }
        boolean needDot = true;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = start; i < this.tokens.size(); ++i) {
            ExpressionToken tok = (ExpressionToken)this.tokens.get(i);
            if (tok instanceof ArrayIndexToken) {
                buf.append(tok.getTokenString());
                needDot = false;
                continue;
            }
            if (tok instanceof IdentifierToken) {
                if (needDot && i != start) {
                    buf.append(".");
                }
                buf.append(tok.toString());
                needDot = true;
                continue;
            }
            if (!(tok instanceof MapKeyToken)) continue;
            buf.append(tok.getTokenString());
            needDot = false;
        }
        buf.append("}");
        return buf.toString();
    }

    public void addToken(ExpressionToken token) {
        this.tokens.add(token);
    }

    public Iterator getExpressionTokens() {
        return this.tokens.iterator();
    }

    public int getTokenCount() {
        return this.tokenArray.length;
    }

    public ExpressionToken getToken(int index) {
        return this.tokenArray[index];
    }

    public String getExpressionString() {
        return this.exprStr;
    }

    public Object evaluate(NetUIVariableResolver vr) {
        return this._evaluate(this.tokens.size(), vr);
    }

    public void update(Object newValue, NetUIVariableResolver vr) {
        Object branch = this._evaluate(this.tokens.size() - 1, vr);
        ExpressionToken token = this.tokenArray[this.tokens.size() - 1];
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Update leaf token: " + token + " on object: " + branch));
        }
        token.update(branch, newValue);
    }

    public String changeContext(String oldContext, String newContext, Object index) {
        ParsedExpression pe;
        String thisExpr = this.getExpressionString();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("oldContext: " + oldContext + " newContext: " + newContext + " thisExpr: " + thisExpr));
        }
        if (!(pe = ParseUtils.parse(newContext)).isExpression()) {
            String msg = "The expression can not be qualified into new context because the new context is not atomic.";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        if (!thisExpr.startsWith(oldContext)) {
            return "{" + thisExpr + "}";
        }
        if (index instanceof Integer && (Integer)index > Short.MAX_VALUE) {
            String msg = "Can not create an indexed expression with an array index greater than the Java array limit for the expression \"" + thisExpr + "\"";
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        String ctxStr = pe.getExpressionString();
        ctxStr = ctxStr + "[" + index + "]";
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("thisExpr: " + thisExpr + " ctxStr: " + ctxStr));
        }
        thisExpr = thisExpr.replaceFirst(oldContext, ctxStr);
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(thisExpr);
        buf.append("}");
        return buf.toString();
    }

    public String qualify(String contextName) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(contextName);
        buf.append(".");
        buf.append(this.getExpressionString());
        buf.append("}");
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ExpressionTerm:\n");
        for (int i = 0; i < this.tokens.size(); ++i) {
            buf.append("  " + this.tokens.get(i).toString() + "\n");
        }
        return buf.toString();
    }

    private final Object _evaluate(int index, NetUIVariableResolver vr) {
        Object result = null;
        if (this.tokens.size() == 1) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"found single term expression");
            }
            if ((result = vr.resolveVariable(this.context.getName())) != null && result instanceof BindingContext) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("result is of type BindingContext; return type: " + ((BindingContext)result).unwrap().getClass()));
                }
                return ((BindingContext)result).unwrap();
            }
            return result;
        }
        for (int i = 0; i < index; ++i) {
            result = i == 0 ? vr.resolveVariable(this.context.getName()) : this.tokenArray[i].evaluate(result);
        }
        return result;
    }
}

