/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script;

import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.netui.script.ExpressionEngineFactory;
import org.apache.beehive.netui.script.ExpressionEvaluator;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.ExpressionLanguages;
import org.apache.beehive.netui.util.config.bean.NetuiConfigDocument;
import org.apache.beehive.netui.util.logging.Logger;

public class ExpressionEvaluatorFactory {
    private static final Logger _logger;
    private static final HashMap FACTORY_MAP;
    private static ExpressionEngineFactory DEFAULT_FACTORY;

    public static final ExpressionEvaluator getInstance() {
        return ExpressionEvaluatorFactory.getInstance(null);
    }

    public static final ExpressionEvaluator getInstance(String name) {
        assert (DEFAULT_FACTORY != null);
        assert (FACTORY_MAP != null);
        if (name == null) {
            return DEFAULT_FACTORY.getInstance();
        }
        if (FACTORY_MAP.containsKey(name)) {
            return ((ExpressionEngineFactory)FACTORY_MAP.get(name)).getInstance();
        }
        String msg = "An ExpressionEvaluator named \"" + name + "\" is not available.";
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)msg);
        }
        throw new IllegalArgumentException(msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final ExpressionEngineFactory initialize(Map factoryMap) {
        String msg;
        assert (factoryMap != null);
        NetuiConfigDocument.NetuiConfig config = ConfigUtil.getConfig();
        assert (config != null);
        ExpressionLanguages languages = config.getExpressionLanguages();
        assert (languages != null);
        ExpressionLanguages.ExpressionLanguage[] array = languages.getExpressionLanguageArray();
        assert (array != null);
        for (int i = 0; i < array.length; ++i) {
            String name = array[i].getName();
            String className = array[i].getFactoryClass();
            ExpressionEngineFactory factory = null;
            try {
                Class<?> type = Class.forName(className);
                factory = (ExpressionEngineFactory)type.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)("Could not create an ExpressionEngineFactory for type \"" + className + "\" because the implementation class could not be found."));
                continue;
            }
            catch (Exception ex) {
                assert (ex instanceof IllegalAccessException || ex instanceof InstantiationException);
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)("Could not create an ExpressionEngineFactory for type \"" + className + "\" because an error occurred creating the factory.  Cause: " + ex), (Throwable)ex);
                continue;
            }
            if (factoryMap.containsKey(name)) {
                if (_logger.isWarnEnabled()) {
                    _logger.warn((Object)("Overwriting a previously defined ExpressionEngineFactory named \"" + name + "\" with a new ExpressionEngineFactory of type \"" + className + "\""));
                } else {
                    _logger.info((Object)("Adding an ExpressionEngineFactory named \"" + name + "\" with implementation \"" + className + "\""));
                }
            }
            factoryMap.put(name, factory);
        }
        ExpressionEngineFactory defaultEngineFactory = null;
        String defaultLanguage = languages.getDefaultLanguage();
        if (defaultLanguage == null) {
            msg = "There is no default expression engine specified.";
            if (!_logger.isErrorEnabled()) throw new RuntimeException(msg);
            _logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        defaultEngineFactory = (ExpressionEngineFactory)factoryMap.get(defaultLanguage);
        if (defaultEngineFactory != null) {
            if (!_logger.isInfoEnabled()) return defaultEngineFactory;
            _logger.info((Object)("Using a default expression evaluator of type \"" + factoryMap.get(defaultLanguage).getClass().getName() + "\""));
            return defaultEngineFactory;
        }
        msg = "The default ExpressionEvaluator named \"" + defaultLanguage + "\" was specified, but the ExpressionEngineFactory could not be found.";
        if (!_logger.isWarnEnabled()) throw new RuntimeException(msg);
        _logger.warn((Object)msg);
        throw new RuntimeException(msg);
    }

    static {
        block2: {
            _logger = Logger.getInstance(ExpressionEvaluatorFactory.class);
            FACTORY_MAP = new HashMap();
            try {
                DEFAULT_FACTORY = ExpressionEvaluatorFactory.initialize(FACTORY_MAP);
            }
            catch (Exception e) {
                DEFAULT_FACTORY = null;
                if (!_logger.isErrorEnabled()) break block2;
                _logger.error((Object)("An exception occurred loading the expression evaluator configuration.  Cause: " + e), (Throwable)e);
            }
        }
    }
}

