/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.beehive.netui.pageflow.util.DOMUtils;
import org.apache.beehive.netui.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UrlTemplateDescriptor {
    private static final String DESCRIPTOR_PATH = "/WEB-INF/url-template-config.xml";
    private static final Logger _log = new Logger(UrlTemplateDescriptor.class);
    private static UrlTemplateDescriptor instance = new UrlTemplateDescriptor();
    private static final String JPF_URL_TEMPLATES = "jpf-url-templates";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String URL_TEMPLATE = "url-template";
    private static final String URL_TEMPLATE_REF = "url-template-ref";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String SECURE_DEFAULT_TEMPLATE = "secure-default";
    public static final String RENDER_TEMPLATE = "render-template";
    public static final String SECURE_RENDER_TEMPLATE = "secure-render-template";
    public static final String ACTION_TEMPLATE = "action";
    public static final String SECURE_ACTION_TEMPLATE = "secure-action-template";
    public static final String RESOURCE_TEMPLATE = "resource-template";
    public static final String SECURE_RESOURCE_TEMPLATE = "secure-resource-template";
    private HashMap _urlTemplates = new HashMap();
    private HashMap _jpfTemplates = new HashMap();
    private boolean _loaded = false;
    private static String[] TEMPLATE_TOKENS = new String[]{"url:scheme", "url:domain", "url:port", "url:prefix", "url:path", "url:queryString"};

    protected UrlTemplateDescriptor() {
    }

    public String getUrlTemplate(String name) {
        return (String)this._urlTemplates.get(name);
    }

    public String getJPFUrlTemplateRef(String type) {
        String ref = (String)this._jpfTemplates.get(type);
        if (ref == null && (type.equals(SECURE_RENDER_TEMPLATE) || type.equals(SECURE_ACTION_TEMPLATE) || type.equals(SECURE_RESOURCE_TEMPLATE))) {
            ref = (String)this._jpfTemplates.get(SECURE_DEFAULT_TEMPLATE);
        }
        return ref;
    }

    public static UrlTemplateDescriptor getInstance() {
        return instance;
    }

    protected void load(InputStream stream) throws Exception {
        DocumentBuilderFactory dbFactory = null;
        dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        dBuilder = dbFactory.newDocumentBuilder();
        Document document = null;
        document = dBuilder.parse(stream);
        Element root = document.getDocumentElement();
        this.loadTemplates(root);
    }

    private void loadTemplates(Element parent) {
        List templates = DOMUtils.getChildElementsByName(parent, URL_TEMPLATE);
        for (int i = 0; i < templates.size(); ++i) {
            Element template = (Element)templates.get(i);
            String name = DOMUtils.getAttributeValue(template, NAME);
            String value = DOMUtils.getElementText(template);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("[URLTemplate] " + name + " = " + value));
            }
            try {
                UrlTemplateDescriptor.verifyTemplate(value);
            }
            catch (IllegalArgumentException ie) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Exception while loading URL templates.", (Throwable)ie);
                continue;
            }
            this._urlTemplates.put(name, value);
        }
        Element jpfTemplatesRoot = DOMUtils.getChildElementByName(parent, JPF_URL_TEMPLATES);
        if (jpfTemplatesRoot != null) {
            List refs = DOMUtils.getChildElementsByName(jpfTemplatesRoot, URL_TEMPLATE_REF);
            for (int i = 0; i < refs.size(); ++i) {
                Element templateRef = (Element)refs.get(i);
                String name = DOMUtils.getAttributeValue(templateRef, TYPE);
                String ref = DOMUtils.getAttributeValue(templateRef, NAME);
                this._jpfTemplates.put(name, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(ServletContext servletContext) {
        if (this._loaded) {
            return;
        }
        InputStream stream = null;
        try {
            stream = servletContext.getResourceAsStream(DESCRIPTOR_PATH);
            if (stream != null) {
                this.load(stream);
            } else {
                _log.warn((Object)"Could not find URL template descriptor at path /WEB-INF/url-template-config.xml");
            }
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Exception while loading URL templates.", (Throwable)e);
            }
            _log.error((Object)"Bad URL template descriptor in path /WEB-INF/url-template-config.xml");
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        this._loaded = true;
    }

    private static void verifyTemplate(String template) throws IllegalStateException {
        for (int i = 0; i < TEMPLATE_TOKENS.length; ++i) {
            int index = template.indexOf(TEMPLATE_TOKENS[i]);
            if (index == -1 || template.charAt(index - 1) == '{' || template.charAt(index + TEMPLATE_TOKENS[i].length()) == '}') continue;
            throw new IllegalStateException("Token " + TEMPLATE_TOKENS[i] + " not enclosed in {}s");
        }
        if (template.indexOf("{url:path}") == -1) {
            throw new IllegalStateException("Required token {url:path} not present in template " + template);
        }
        if (template.indexOf("{url:queryString}") == -1) {
            throw new IllegalStateException("Required token {url:queryString} not present in template " + template);
        }
    }
}

