/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.util;

import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.core.urls.MutableURI;
import org.apache.beehive.netui.core.urls.URLRewriter;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.SecurityProtocol;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.util.DefaultURLRewriter;
import org.apache.beehive.netui.pageflow.util.OldURLRewriterWrapper;
import org.apache.beehive.netui.pageflow.util.URLRewriter;
import org.apache.beehive.netui.util.logging.Logger;

public class URLRewriterService {
    private static URLRewriter defaultRewriter = new DefaultURLRewriter();
    private static String URL_REWRITER_KEY = "url_rewriter";
    private static final Logger _log = Logger.getInstance(URLRewriterService.class);

    public static final URLRewriter getDefaultRewriter() {
        return new DefaultURLRewriter();
    }

    public static String rewriteName(ServletContext servletContext, ServletRequest request, String name) {
        return org.apache.beehive.netui.core.urls.URLRewriterService.rewriteName((ServletContext)servletContext, (ServletRequest)request, (String)name);
    }

    public static String rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, String url, String type) {
        return URLRewriterService.rewriteURL(servletContext, request, response, url, type, true);
    }

    public static String rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, String url, String type, boolean doEncode) {
        String rewrittenURL = null;
        MutableURI mutableUri = null;
        try {
            mutableUri = new MutableURI(url);
            mutableUri.setEncoding(response.getCharacterEncoding());
            URLRewriter.URLType tempType = URLRewriter.URLType.RESOURCE;
            boolean needsToBeSecure = false;
            if (type.equals(URLRewriter.ACTION_UNSECURE)) {
                tempType = URLRewriter.URLType.ACTION;
            } else if (type.equals(URLRewriter.ACTION_SECURE)) {
                tempType = URLRewriter.URLType.ACTION;
                needsToBeSecure = true;
            } else if (type.equals(URLRewriter.RESOURCE_SECURE)) {
                needsToBeSecure = true;
            }
            org.apache.beehive.netui.core.urls.URLRewriterService.rewriteURL((ServletContext)servletContext, (ServletRequest)request, (ServletResponse)response, (MutableURI)mutableUri, (URLRewriter.URLType)tempType, (boolean)needsToBeSecure);
            rewrittenURL = mutableUri.toString();
        }
        catch (URISyntaxException e) {
            _log.error((Object)("Invalid URI: " + url));
            rewrittenURL = url;
        }
        if (doEncode) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            rewrittenURL = httpResponse.encodeRedirectURL(rewrittenURL.toString());
        }
        return rewrittenURL;
    }

    public static void registerURLRewriter(ServletRequest request, URLRewriter rewriter) {
        request.setAttribute(URL_REWRITER_KEY, (Object)rewriter);
        OldURLRewriterWrapper rewriterWrapper = new OldURLRewriterWrapper(rewriter);
        rewriterWrapper.setAllowOtherRewriters(false);
        org.apache.beehive.netui.core.urls.URLRewriterService.unregisterAllURLRewriters((ServletRequest)request);
        org.apache.beehive.netui.core.urls.URLRewriterService.registerURLRewriter((ServletRequest)request, (org.apache.beehive.netui.core.urls.URLRewriter)rewriterWrapper);
    }

    public static URLRewriter unregisterURLRewriter(ServletRequest request) {
        URLRewriter rewriter = (URLRewriter)request.getAttribute(URL_REWRITER_KEY);
        request.removeAttribute(URL_REWRITER_KEY);
        OldURLRewriterWrapper rewriterWrapper = new OldURLRewriterWrapper(rewriter);
        org.apache.beehive.netui.core.urls.URLRewriterService.unregisterURLRewriter((ServletRequest)request, (org.apache.beehive.netui.core.urls.URLRewriter)rewriterWrapper);
        return rewriter;
    }

    public static String getActionMappingName(String action) {
        return InternalUtils.getActionMappingName(action);
    }

    public static boolean needsSecure(ServletRequest request, ServletContext context, String uri, boolean stripContextPath) {
        SecurityProtocol sp;
        String contextPath;
        String secureCheck = uri;
        if (stripContextPath && secureCheck.startsWith(contextPath = ((HttpServletRequest)request).getContextPath())) {
            secureCheck = secureCheck.substring(contextPath.length());
        }
        boolean secure = false;
        if (secureCheck.indexOf("?") > -1) {
            secureCheck = secureCheck.substring(0, secureCheck.indexOf("?"));
        }
        secure = (sp = PageFlowUtils.getSecurityProtocol(secureCheck, context, (HttpServletRequest)request)).equals((Object)SecurityProtocol.UNSPECIFIED) ? request.isSecure() : sp.equals((Object)SecurityProtocol.SECURE);
        return secure;
    }

    public static boolean allowParamsOnFormAction(ServletContext servletContext, ServletRequest request) {
        return org.apache.beehive.netui.core.urls.URLRewriterService.allowParamsOnFormAction((ServletContext)servletContext, (ServletRequest)request);
    }
}

