/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.util;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.ServerAdapter;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.util.TemplateHelper;
import org.apache.beehive.netui.pageflow.util.URLRewriter;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.logging.Logger;

public class DefaultURLRewriter
extends URLRewriter {
    private static final Logger _log = Logger.getInstance(DefaultURLRewriter.class);

    public String rewriteName(ServletContext servletContext, ServletRequest request, String name) {
        URLRewriter next = this.getNextRewriter();
        return next != null ? next.rewriteName(servletContext, request, name) : name;
    }

    public String rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, String url, String type) {
        URLRewriter next;
        TemplateHelper templateHelper = new TemplateHelper((HttpServletRequest)request, (HttpServletResponse)response);
        if (templateHelper.hasTemplateRef(type)) {
            templateHelper.setTemplate(templateHelper.getTemplateName(type));
            templateHelper.setUrl(url);
            url = templateHelper.toString();
        } else {
            ServerAdapter serverAdapter = ServerAdapterManager.getServerAdapter(servletContext);
            if (type.equals(URLRewriter.ACTION_SECURE) || type.equals(URLRewriter.RESOURCE_SECURE)) {
                if (!request.isSecure()) {
                    int securePort = serverAdapter.getSecureListenPort((HttpServletRequest)request);
                    if (securePort != -1) {
                        url = this.internalRewriteUrl(url, "https", securePort, request.getServerName());
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Could not rewrite URL " + url + " to be secure because a secure port was" + " not provided by the ServerAdapter."));
                    }
                }
            } else if (request.isSecure()) {
                int listenPort = serverAdapter.getListenPort((HttpServletRequest)request);
                if (listenPort != -1) {
                    url = this.internalRewriteUrl(url, "http", listenPort, request.getServerName());
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Could not rewrite URL " + url + " to be secure because a secure port was" + " not provided by the ServerAdapter."));
                }
            }
        }
        String scopeID = request.getParameter("jpfScopeID");
        if (scopeID != null) {
            url = InternalUtils.addParam(url, "jpfScopeID", scopeID);
        }
        return (next = this.getNextRewriter()) != null ? next.rewriteURL(servletContext, request, response, url, type) : url;
    }

    private String internalRewriteUrl(String url, String protocol, int port, String serverName) {
        if (!FileUtils.isAbsoluteURI((String)url)) {
            StringBuilder urlBuf = new StringBuilder(protocol);
            urlBuf.append("://");
            urlBuf.append(serverName);
            urlBuf.append(":");
            urlBuf.append(port);
            urlBuf.append(url);
            url = urlBuf.toString();
        }
        return url;
    }
}

