/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.util;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

abstract class DOMUtils {
    DOMUtils() {
    }

    public static Element getChildElementByName(Element parent, String name) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public static List getChildElementsByName(Element parent, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals(name)) continue;
            elements.add(element);
        }
        return elements;
    }

    public static String getChildElementText(Element parent, String name) {
        List list = DOMUtils.getChildElementsByName(parent, name);
        if (list.size() == 1) {
            Element child = (Element)list.get(0);
            StringBuilder buf = new StringBuilder();
            NodeList children = child.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
                Text text = (Text)node;
                buf.append(text.getData().trim());
            }
            return buf.toString();
        }
        return null;
    }

    public static String getElementText(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            Text text = (Text)node;
            buf.append(text.getData().trim());
        }
        return buf.toString();
    }

    public static String[] getChildElementTextArr(Element parent, String name) {
        List children = DOMUtils.getChildElementsByName(parent, name);
        String[] str = new String[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            Node child = (Node)children.get(i);
            StringBuilder buf = new StringBuilder();
            NodeList nodes = child.getChildNodes();
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node node = nodes.item(j);
                if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
                Text text = (Text)node;
                buf.append(text.getData().trim());
            }
            str[i] = buf.toString();
        }
        return str;
    }

    public static String getAttributeValue(Element element, String name) {
        Attr attribute = element.getAttributeNode(name);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }
}

