/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.FacesBackingBean;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.logging.Logger;

public class FacesBackingBeanFactory {
    private static final Logger _log = Logger.getInstance(FacesBackingBeanFactory.class);

    public static FacesBackingBean getFacesBackingBeanForRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        String uri = InternalUtils.getDecodedServletPath(request);
        assert (uri.charAt(0) == '/') : uri;
        String backingClassName = FileUtils.stripFileExtension((String)uri.substring(1).replace('/', '.'));
        FacesBackingBean currentBean = InternalUtils.getFacesBackingBean((ServletRequest)request);
        if (currentBean == null || !currentBean.getClass().getName().equals(backingClassName)) {
            FacesBackingBean bean = null;
            try {
                Class backingClass = ContextCache.get(servletContext).getReloadableClassHandler().loadCachedClass(backingClassName);
                if (backingClass == null) {
                    if (_log.isTraceEnabled()) {
                        _log.trace((Object)("No backing bean class " + backingClassName + " found for request " + request.getRequestURI()));
                    }
                } else if (backingClass.getAnnotation(Jpf.FacesBacking.class) != null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Found backing class " + backingClassName + " for request " + request.getRequestURI() + "; creating a new instance."));
                    }
                    bean = (FacesBackingBean)backingClass.newInstance();
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found matching backing class " + backingClassName + " for request " + request.getRequestURI() + ", but it does not have the " + Jpf.FacesBacking.class.getName() + " annotation."));
                }
            }
            catch (InstantiationException e) {
                _log.error((Object)("Could not create backing bean instance of " + backingClassName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                _log.error((Object)("Could not create backing bean instance of " + backingClassName), (Throwable)e);
            }
            if (bean == null && (FileUtils.uriEndsWith((String)uri, (String)"faces") || FileUtils.uriEndsWith((String)uri, (String)"jsf"))) {
                bean = new DefaultFacesBackingBean();
            }
            if (bean != null) {
                try {
                    bean.create(request, response, servletContext);
                }
                catch (Exception e) {
                    _log.error((Object)("Error while creating backing bean instance of " + backingClassName), (Throwable)e);
                }
                bean.persistInSession(request, response);
                return bean;
            }
            HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
            ScopedServletUtils.removeScopedSessionAttr((String)"_netui:facesBacking", (HttpServletRequest)unwrappedRequest);
            request.getSession().removeAttribute("_netui:facesBacking");
        } else if (currentBean != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using existing backing bean instance " + currentBean + " for request " + request.getRequestURI()));
            }
            currentBean.reinitialize(request, response, servletContext);
        }
        return currentBean;
    }

    private static class DefaultFacesBackingBean
    extends FacesBackingBean {
        private DefaultFacesBackingBean() {
        }
    }
}

