/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.beehive.netui.pageflow.AutoRegisterActionServlet;
import org.apache.beehive.netui.pageflow.handler.ReloadableClassHandler;
import org.apache.beehive.netui.pageflow.internal.DefaultHandler;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.util.DiscoveryUtils;
import org.apache.beehive.netui.util.cache.ClassLevelCache;
import org.apache.beehive.netui.util.classloader.BouncyClassLoader;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionServlet;

public class DefaultReloadableClassHandler
extends DefaultHandler
implements ReloadableClassHandler {
    private static final Logger _log = Logger.getInstance(DefaultReloadableClassHandler.class);
    private BouncyClassLoader _pageFlowClassLoader = null;
    private static Map<String, Class> _loadedClasses = new ConcurrentHashMap<String, Class>();
    private static Class NULL_CLASS = Null.class;

    public void init(ServletContext servletContext) {
        super.init(servletContext);
    }

    public Object newInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.loadClass(className).newInstance();
    }

    public Class loadCachedClass(String className) {
        Class clazz = _loadedClasses.get(className);
        if (clazz != null) {
            return clazz != NULL_CLASS ? clazz : null;
        }
        try {
            clazz = this.loadClass(className);
            _loadedClasses.put(className, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            _loadedClasses.put(className, NULL_CLASS);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className) throws ClassNotFoundException {
        if (this._pageFlowClassLoader != null) {
            DefaultReloadableClassHandler defaultReloadableClassHandler = this;
            synchronized (defaultReloadableClassHandler) {
                return this._pageFlowClassLoader.loadClass(className);
            }
        }
        return DiscoveryUtils.getClassLoader().loadClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinit(HttpServletRequest request) {
        if (this._pageFlowClassLoader == null) {
            return;
        }
        DefaultReloadableClassHandler defaultReloadableClassHandler = this;
        synchronized (defaultReloadableClassHandler) {
            if (this._pageFlowClassLoader.isStale()) {
                _log.debug((Object)"Classes modified; bouncing classloader.");
                HttpSession session = request.getSession(false);
                if (session != null) {
                    Enumeration e = session.getAttributeNames();
                    while (e.hasMoreElements()) {
                        String attrName = (String)e.nextElement();
                        Object attr = session.getAttribute(attrName);
                        if (attr.getClass().getClassLoader() != this._pageFlowClassLoader) continue;
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Removing session attribute " + attrName + " (" + attr + ") because its ClassLoader is being bounced."));
                        }
                        session.removeAttribute(attrName);
                    }
                }
                ClassLevelCache.clearAll();
                ActionServlet actionServlet = InternalUtils.getActionServlet(this.getServletContext());
                if (actionServlet instanceof AutoRegisterActionServlet) {
                    ((AutoRegisterActionServlet)actionServlet).clearRegisteredModules();
                }
                this.init(this.getServletContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        if (this._pageFlowClassLoader != null) {
            DefaultReloadableClassHandler defaultReloadableClassHandler = this;
            synchronized (defaultReloadableClassHandler) {
                return this._pageFlowClassLoader;
            }
        }
        return this._pageFlowClassLoader;
    }

    public boolean isReloadEnabled() {
        return this._pageFlowClassLoader != null;
    }

    private static class Null {
        private Null() {
        }
    }
}

