/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.FormData;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowManagedObjectException;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.config.PageFlowExceptionConfig;
import org.apache.beehive.netui.pageflow.handler.ExceptionsHandler;
import org.apache.beehive.netui.pageflow.internal.DefaultHandler;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.cache.ClassLevelCache;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class DefaultExceptionsHandler
extends DefaultHandler
implements ExceptionsHandler {
    private static final Logger _log = Logger.getInstance(DefaultExceptionsHandler.class);
    private static final String CACHEID_EXCEPTION_HANDLER_METHODS = "_netui:exceptionHandlers";

    public ActionForward handleException(Throwable ex, ActionMapping actionMapping, ActionForm form, FlowController flowController, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Handling uncaught Throwable " + ex.getClass().getName()));
        }
        Class<?> exClass = ex.getClass();
        ExceptionConfig exceptionConfig = null;
        exceptionConfig = actionMapping != null ? actionMapping.findException(exClass) : this.getExceptionConfig(exClass, flowController.getModuleConfig());
        if (exceptionConfig == null) {
            FlowController fallbackFC = this.getFallbackFlowController(flowController, exClass, request, response, servletContext);
            if (fallbackFC != null) {
                flowController = fallbackFC;
                exceptionConfig = this.getExceptionConfig(exClass, fallbackFC.getModuleConfig());
            }
            actionMapping = null;
        }
        if (exceptionConfig != null) {
            PageFlowExceptionConfig pfExceptionConfig;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Found exception-config for exception " + exClass.getName() + ": handler=" + exceptionConfig.getHandler() + ", path=" + exceptionConfig.getPath()));
            }
            if (exceptionConfig instanceof PageFlowExceptionConfig && (pfExceptionConfig = (PageFlowExceptionConfig)exceptionConfig).isHandlerMethod()) {
                return this.invokeExceptionHandlerMethod(ex, pfExceptionConfig, form, actionMapping, flowController, request, response, servletContext);
            }
            return this.invokeExceptionHandlerClass(ex, exceptionConfig, actionMapping, form, request, response);
        }
        if (_log.isErrorEnabled()) {
            StringBuilder msg = new StringBuilder("Throwable ").append(exClass.getName());
            _log.error((Object)msg.append(" unhandled by the current page flow (and any shared flow)").toString(), ex);
        }
        if (!this.eatUnhandledException(ex, request, response, servletContext)) {
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new ServletException(ex);
        }
        return null;
    }

    public Throwable unwrapException(Throwable ex) {
        ServletException servletException;
        Throwable rootCause;
        if (ex instanceof InvocationTargetException) {
            return this.unwrapException(((InvocationTargetException)ex).getTargetException());
        }
        if (ex instanceof UndeclaredThrowableException) {
            return this.unwrapException(((UndeclaredThrowableException)ex).getUndeclaredThrowable());
        }
        if (ex instanceof ServletException && (rootCause = (servletException = (ServletException)ex).getRootCause()) != null) {
            return this.unwrapException(rootCause);
        }
        return ex;
    }

    public void exposeException(Throwable ex, ActionMapping actionMapping, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        request.setAttribute("org.apache.struts.action.EXCEPTION", (Object)ex);
    }

    protected ExceptionConfig getExceptionConfig(Class exceptionType, ModuleConfig moduleConfig) {
        ExceptionConfig config = null;
        if (moduleConfig != null) {
            while (config == null && exceptionType != null) {
                config = moduleConfig.findExceptionConfig(exceptionType.getName());
                exceptionType = exceptionType.getSuperclass();
            }
        }
        return config;
    }

    protected FlowController getFallbackFlowController(FlowController originalFlowController, Class exClass, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        if (originalFlowController instanceof PageFlowController) {
            Collection<SharedFlowController> sharedFlows = ((PageFlowController)originalFlowController).getSharedFlows().values();
            for (SharedFlowController sf : sharedFlows) {
                ModuleConfig mc = sf.getModuleConfig();
                ExceptionConfig ec = this.getExceptionConfig(exClass, mc);
                if (ec == null) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found exception-config for " + exClass.getName() + " in SharedFlowController " + sf.getDisplayName()));
                }
                InternalUtils.setCurrentModule(mc, (ServletRequest)request);
                return sf;
            }
        }
        return null;
    }

    protected ActionForward invokeExceptionHandlerClass(Throwable throwable, ExceptionConfig exceptionConfig, ActionMapping actionMapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String handlerClassName = exceptionConfig.getHandler();
        try {
            ExceptionHandler handler = (ExceptionHandler)RequestUtils.applicationInstance((String)handlerClassName);
            Exception ex = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            ActionForward result = handler.execute(ex, exceptionConfig, actionMapping, form, request, response);
            if (exceptionConfig instanceof PageFlowExceptionConfig && ((PageFlowExceptionConfig)exceptionConfig).isPathContextRelative()) {
                result.setContextRelative(true);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Exception-handler: forward to " + result.getPath()));
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            _log.error((Object)("Could not find exception-handler class " + handlerClassName), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            _log.error((Object)("Could not create instance of exception-handler class " + handlerClassName), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            _log.error((Object)("Could not create instance of exception-handler class " + handlerClassName), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected ActionForward invokeExceptionHandlerMethod(Throwable ex, PageFlowExceptionConfig exceptionConfig, ActionForm form, ActionMapping actionMapping, FlowController flowController, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        Object unwrappedFormBean;
        String methodName = exceptionConfig.getHandler();
        Method method = this.getExceptionHandlerMethod(methodName, ex, unwrappedFormBean = InternalUtils.unwrapFormBean(form), flowController);
        if (method != null) {
            String message = exceptionConfig.getDefaultMessage();
            String messageKey = exceptionConfig.getKey();
            if (messageKey != null && messageKey.length() > 0) {
                message = this.getMessage(messageKey, null, null, request, servletContext, flowController);
            }
            return flowController.invokeExceptionHandler(method, ex, message, unwrappedFormBean, form, actionMapping, request, response, exceptionConfig.isReadonly());
        }
        String err = form != null ? Bundle.getString((String)"PageFlow_MissingExceptionHandlerWithForm", (Object[])new Object[]{methodName, form.getClass().getName()}) : Bundle.getString((String)"PageFlow_MissingExceptionHandler", (Object)methodName);
        InternalUtils.sendError("PageFlow_Custom_Error", null, request, response, servletContext, flowController.getDisplayName(), err);
        return null;
    }

    protected String getMessage(String messageKey, String bundle, Object[] args, HttpServletRequest request, ServletContext servletContext, FlowController flowController) {
        MessageResources resources;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((resources = (MessageResources)request.getAttribute(bundle)) == null) {
            resources = (MessageResources)servletContext.getAttribute(bundle);
        }
        if (resources == null) {
            _log.error((Object)("Could not find message-resources for bundle " + bundle));
            return null;
        }
        Locale userLocale = FlowController.retrieveUserLocale(request, null);
        if (args == null) {
            return resources.getMessage(userLocale, messageKey);
        }
        return resources.getMessage(userLocale, messageKey, args);
    }

    public boolean eatUnhandledException(Throwable ex, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        _log.error((Object)"Unhandled Page Flow Exception", ex);
        try {
            boolean prodMode = ServerAdapterManager.getServerAdapter(servletContext).isInProductionMode();
            if (!prodMode && ex instanceof PageFlowManagedObjectException) {
                ((PageFlowManagedObjectException)ex).sendError(request, response);
                return true;
            }
        }
        catch (IOException ioEx) {
            _log.error((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
        return false;
    }

    protected Method getExceptionHandlerMethod(String methodName, Throwable ex, Object formBean, FlowController flowController) {
        String cacheKey = methodName + '/' + ex.getClass().getName();
        ClassLevelCache cache = ClassLevelCache.getCache(flowController.getClass());
        Method method = (Method)cache.get(CACHEID_EXCEPTION_HANDLER_METHODS, cacheKey);
        if (method != null) {
            return method;
        }
        Class<?> flowControllerClass = flowController.getClass();
        for (Class<?> exClass = ex.getClass(); exClass != null; exClass = exClass.getSuperclass()) {
            Class[] args = new Class[]{exClass, String.class, String.class, Object.class};
            Method foundMethod = InternalUtils.lookupMethod(flowControllerClass, methodName, args);
            if (foundMethod == null && (formBean == null || formBean instanceof FormData)) {
                args = new Class[]{exClass, String.class, String.class, FormData.class};
                foundMethod = InternalUtils.lookupMethod(flowControllerClass, methodName, args);
            }
            if (foundMethod == null && (formBean == null || formBean instanceof ActionForm)) {
                args = new Class[]{exClass, String.class, String.class, ActionForm.class};
                foundMethod = InternalUtils.lookupMethod(flowControllerClass, methodName, args);
            }
            if (foundMethod != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found exception handler for " + exClass.getName()));
                }
                foundMethod.setAccessible(true);
                cache.put(CACHEID_EXCEPTION_HANDLER_METHODS, cacheKey, (Object)foundMethod);
                return foundMethod;
            }
            if (!_log.isErrorEnabled()) continue;
            StringBuilder msg = new StringBuilder("Could not find exception handler method ");
            msg.append(methodName).append(" for ").append(exClass.getName()).append('.');
            _log.error((Object)msg.toString());
        }
        return null;
    }
}

