/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.interceptor;

import java.io.Serializable;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorChainConfig;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorConfig;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.ActionInterceptor;
import org.apache.beehive.netui.util.config.bean.PageflowActionInterceptors;

class ActionInterceptorsConfig
implements Serializable {
    private ActionInterceptorChainConfig _beforeAllActions;
    private ActionInterceptorChainConfig _afterAllActions;
    public static final int BEFORE_ACTION = 1;
    public static final int AFTER_ACTION = 2;

    public ActionInterceptorsConfig() {
        PageflowActionInterceptors.Global global;
        PageflowActionInterceptors ai;
        if (ConfigUtil.getConfig() != null && (ai = ConfigUtil.getConfig().getPageflowActionInterceptors()) != null && (global = ai.getGlobal()) != null) {
            PageflowActionInterceptors.Global.AfterAction afterAction;
            PageflowActionInterceptors.Global.BeforeAction beforeAction = global.getBeforeAction();
            if (beforeAction != null) {
                this._beforeAllActions = ActionInterceptorsConfig.loadChainConfig(beforeAction.getActionInterceptorArray());
            }
            if ((afterAction = global.getAfterAction()) != null) {
                this._afterAllActions = ActionInterceptorsConfig.loadChainConfig(afterAction.getActionInterceptorArray());
            }
        }
    }

    private static ActionInterceptorChainConfig loadChainConfig(ActionInterceptor[] interceptors) {
        ActionInterceptorConfig[] configs = new ActionInterceptorConfig[interceptors.length];
        for (int i = 0; i < interceptors.length; ++i) {
            configs[i] = new ActionInterceptorConfig(interceptors[i].getInterceptorClass());
        }
        ActionInterceptorChainConfig config = new ActionInterceptorChainConfig();
        config.setInterceptors(configs);
        return config;
    }

    public ActionInterceptorChainConfig getChainConfig(int type) {
        switch (type) {
            case 1: {
                return this._beforeAllActions;
            }
            case 2: {
                return this._afterAllActions;
            }
        }
        assert (false) : "unknown type " + type;
        return null;
    }

    public ActionInterceptorChainConfig getBeforeAllActions() {
        return this._beforeAllActions;
    }

    public ActionInterceptorChainConfig getAfterAllActions() {
        return this._afterAllActions;
    }
}

