/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.faces.internal;

import java.io.IOException;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.FlowControllerFactory;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.util.logging.Logger;

public class PageFlowNavigationHandler
extends NavigationHandler {
    private static final Logger _log = Logger.getInstance(PageFlowNavigationHandler.class);
    static final String ALREADY_FORWARDED_ATTR = "_netui:navHandled";
    private NavigationHandler _baseHandler;

    public PageFlowNavigationHandler(NavigationHandler base) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adapting NavigationHandler" + base));
        }
        this._baseHandler = base;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        Object request = context.getExternalContext().getRequest();
        Object response = context.getExternalContext().getResponse();
        Object extContext = context.getExternalContext().getContext();
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && extContext instanceof ServletContext) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (httpRequest.getAttribute(ALREADY_FORWARDED_ATTR) != null) {
                httpRequest.removeAttribute(ALREADY_FORWARDED_ATTR);
                return;
            }
            ServletContext servletContext = (ServletContext)extContext;
            PageFlowController pfc = FlowControllerFactory.getPageFlowForRequest(httpRequest, httpResponse, servletContext);
            PageFlowUtils.getCurrentPageFlow(httpRequest);
            if (pfc != null) {
                if (outcome != null) {
                    String actionURI = outcome + ".do";
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Forwarding to " + actionURI));
                    }
                    context.responseComplete();
                    context.setViewRoot(null);
                    httpRequest.setAttribute(ALREADY_FORWARDED_ATTR, (Object)Boolean.TRUE);
                    try {
                        httpRequest.getRequestDispatcher(actionURI).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    }
                    catch (IOException e) {
                        _log.error((Object)("Could not forward to " + actionURI), (Throwable)e);
                    }
                    catch (ServletException e) {
                        _log.error((Object)("Could not forward to " + actionURI), e.getRootCause());
                    }
                }
                return;
            }
        }
        this._baseHandler.handleNavigation(context, fromAction, outcome);
    }
}

