/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.faces.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.beehive.netui.pageflow.FacesBackingBean;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.RequestValues;

public class BackingClassMethodBinding
extends MethodBinding
implements StateHolder {
    private String _methodName;
    private Class[] _params;
    private MethodBinding _delegate;
    private boolean _transient = false;

    public BackingClassMethodBinding() {
    }

    public BackingClassMethodBinding(String methodName, Class[] params, MethodBinding delegate) {
        this._methodName = methodName;
        this._params = params;
        this._delegate = delegate;
    }

    public Class getType(FacesContext context) throws MethodNotFoundException {
        return this._delegate.getType(context);
    }

    public String getExpressionString() {
        return this._delegate.getExpressionString();
    }

    public Object invoke(FacesContext context, Object[] params) throws EvaluationException, MethodNotFoundException {
        Object result = this._delegate.invoke(context, params);
        if (result instanceof String) {
            String action = (String)result;
            Object request = context.getExternalContext().getRequest();
            assert (request != null);
            assert (request instanceof HttpServletRequest) : request.getClass().getName();
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            FacesBackingBean backingBean = InternalUtils.getFacesBackingBean((ServletRequest)httpRequest);
            if (backingBean != null) {
                Class<?> backingClass = backingBean.getClass();
                try {
                    Method method = backingClass.getMethod(this._methodName, this._params);
                    Jpf.CommandHandler ann = method.getAnnotation(Jpf.CommandHandler.class);
                    if (ann != null) {
                        Jpf.RaiseAction[] raiseActions = ann.raiseActions();
                        for (int i = 0; i < raiseActions.length; ++i) {
                            String formBeanMember;
                            Jpf.RaiseAction raiseAction = raiseActions[i];
                            if (!raiseAction.action().equals(action) || (formBeanMember = raiseAction.outputFormBean()).length() <= 0) continue;
                            try {
                                Field field = backingClass.getDeclaredField(formBeanMember);
                                field.setAccessible(true);
                                Object value = field.get(backingBean);
                                RequestValues.setForwardedFormBean((ServletRequest)httpRequest, InternalUtils.wrapFormBean(value));
                                continue;
                            }
                            catch (NoSuchFieldException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this._methodName, this._params, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this._delegate)};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._methodName = (String)values[0];
        this._params = (Class[])values[1];
        this._delegate = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[2]);
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }
}

