/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.util.config.bean.PageflowConfig;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.upload.CommonsMultipartRequestHandler;
import org.apache.struts.upload.DiskMultipartRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowControllerConfig
extends ControllerConfig {
    private static final String MEMORY_MULTIPART_HANDLER_CLASS = CommonsMultipartRequestHandler.class.getName();
    private static final String DISK_MULTIPART_HANDLER_CLASS = DiskMultipartRequestHandler.class.getName();
    private boolean _isNestedPageFlow;
    private boolean _isLongLivedPageFlow;
    private boolean _isReturnToPageDisabled;
    private boolean _isReturnToActionDisabled;
    private boolean _isMissingDefaultMessages;
    private LinkedHashMap<String, String> _sharedFlowTypes;
    private String _controllerClass;
    private boolean _isSharedFlow;
    private String _overrideMultipartClass = null;
    private boolean _forceMultipartDisabled = false;

    public boolean isNestedPageFlow() {
        return this._isNestedPageFlow;
    }

    public void setIsNestedPageFlow(boolean nestedPageFlow) {
        this._isNestedPageFlow = nestedPageFlow;
    }

    public boolean isLongLivedPageFlow() {
        return this._isLongLivedPageFlow;
    }

    public void setIsLongLivedPageFlow(boolean longLivedPageFlow) {
        this._isLongLivedPageFlow = longLivedPageFlow;
    }

    public boolean isReturnToPageDisabled() {
        return this._isReturnToPageDisabled;
    }

    public void setIsReturnToPageDisabled(boolean returnToPageDisabled) {
        this._isReturnToPageDisabled = returnToPageDisabled;
    }

    public boolean isReturnToActionDisabled() {
        return this._isReturnToActionDisabled;
    }

    public void setIsReturnToActionDisabled(boolean returnToActionDisabled) {
        this._isReturnToActionDisabled = returnToActionDisabled;
    }

    public boolean isMissingDefaultMessages() {
        return this._isMissingDefaultMessages;
    }

    public void setIsMissingDefaultMessages(boolean missingDefaultMessages) {
        this._isMissingDefaultMessages = missingDefaultMessages;
    }

    public void setSharedFlows(String sharedFlows) {
        if (sharedFlows == null || sharedFlows.length() == 0) {
            this._sharedFlowTypes = null;
            return;
        }
        String[] keyValues = sharedFlows.split(",");
        this._sharedFlowTypes = new LinkedHashMap();
        for (int i = 0; i < keyValues.length; ++i) {
            String keyValue = keyValues[i];
            int delim = keyValue.indexOf(61);
            assert (delim != -1) : "no delimiter in " + keyValue;
            assert (delim < keyValue.length() - 1) : "missing value in " + keyValue;
            this._sharedFlowTypes.put(keyValue.substring(0, delim), keyValue.substring(delim + 1));
        }
    }

    public String getSharedFlows() {
        throw new UnsupportedOperationException("not implemented; uses getSharedFlowTypes");
    }

    public Map<String, String> getSharedFlowTypes() {
        return this._sharedFlowTypes;
    }

    public String getControllerClass() {
        return this._controllerClass;
    }

    public void setControllerClass(String controllerClass) {
        this._controllerClass = controllerClass;
    }

    public boolean isSharedFlow() {
        return this._isSharedFlow;
    }

    public void setIsSharedFlow(boolean sharedFlow) {
        this._isSharedFlow = sharedFlow;
    }

    public String getMultipartClass() {
        if (this._forceMultipartDisabled) {
            return null;
        }
        if (this._overrideMultipartClass != null) {
            return this._overrideMultipartClass;
        }
        PageflowConfig.MultipartHandler.Enum mpHandler = InternalUtils.getMultipartHandlerType();
        if (mpHandler != null) {
            switch (mpHandler.intValue()) {
                case 1: {
                    return null;
                }
                case 2: {
                    return MEMORY_MULTIPART_HANDLER_CLASS;
                }
                case 3: {
                    return DISK_MULTIPART_HANDLER_CLASS;
                }
            }
            assert (false) : "unknown value for multipart handler: " + mpHandler.toString();
        }
        return null;
    }

    public String getTempDir() {
        return this.tempDir != null ? this.tempDir : System.getProperty("java.io.tmpdir");
    }

    public void setMultipartClass(String overrideMultipartClass) {
        if (overrideMultipartClass.equals("none")) {
            this._forceMultipartDisabled = true;
        } else {
            this._overrideMultipartClass = overrideMultipartClass;
        }
    }
}

