/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.beehive.netui.core.urls.MutableURI;
import org.apache.beehive.netui.core.urls.URLRewriter;
import org.apache.beehive.netui.core.urls.URLRewriterService;
import org.apache.beehive.netui.pageflow.ActionResolver;
import org.apache.beehive.netui.pageflow.ActionResult;
import org.apache.beehive.netui.pageflow.FlowControllerFactory;
import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.PageFlowActionServlet;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowStack;
import org.apache.beehive.netui.pageflow.SecurityProtocol;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.config.PageFlowActionFormBean;
import org.apache.beehive.netui.pageflow.internal.ActionResultImpl;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.RequestValues;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.scoping.ScopedRequest;
import org.apache.beehive.netui.pageflow.scoping.ScopedResponse;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.pageflow.scoping.internal.ScopedRequestImpl;
import org.apache.beehive.netui.script.common.ImplicitObjectUtil;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.ServletUtils;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.RequestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowUtils {
    private static final Logger _log = Logger.getInstance(PageFlowUtils.class);
    private static final String ACTION_URI_ATTR = "_netui:_actionURI";
    private static final int JPF_EXTENSION_LEN = ".jpf".length();
    private static final String[] DEFAULT_AUTORESOLVE_EXTENSIONS = new String[]{".do", ".jpf"};
    private static Map<String, Map<String, String>> _formNameMaps = new ConcurrentHashMap<String, Map<String, String>>();

    public static String getModulePath(HttpServletRequest request, String requestURI) {
        return PageFlowUtils.getModulePathForRelativeURI(PageFlowUtils.getRelativeURI(request, requestURI, null));
    }

    public static String getModulePath(HttpServletRequest request) {
        return PageFlowUtils.getModulePathForRelativeURI(InternalUtils.getDecodedServletPath(request));
    }

    public static String getModulePathForRelativeURI(String uri) {
        assert (uri.length() > 0);
        assert (uri.charAt(0) == '/') : uri;
        int slash = uri.lastIndexOf(47);
        uri = uri.substring(0, slash);
        return uri;
    }

    public static final String getRelativeURI(HttpServletRequest request, PageFlowController relativeTo) {
        return PageFlowUtils.getRelativeURI(request, InternalUtils.getDecodedURI(request), relativeTo);
    }

    public static final String getRelativeURI(HttpServletRequest request, String uri, PageFlowController relativeTo) {
        String contextPath = request.getContextPath();
        if (relativeTo != null) {
            contextPath = contextPath + relativeTo.getModulePath();
        }
        return ScopedServletUtils.getRelativeURI((String)contextPath, (String)uri);
    }

    public static String getBeginActionURI(String requestURI) {
        StringBuilder retVal = new StringBuilder();
        int lastSlash = requestURI.lastIndexOf(47);
        if (lastSlash != -1) {
            retVal.append(requestURI.substring(0, lastSlash));
        }
        retVal.append('/').append("begin").append(".do");
        return retVal.toString();
    }

    public static final Stack getPageFlowStack(HttpServletRequest request) {
        return PageFlowStack.get(request, true).getLegacyStack();
    }

    public static void destroyPageFlowStack(HttpServletRequest request) {
        PageFlowStack.destroy(request);
    }

    public static PageFlowController getNestingPageFlow(HttpServletRequest request) {
        PageFlowStack jpfStack = PageFlowStack.get(request, false);
        if (jpfStack != null && !jpfStack.isEmpty()) {
            PageFlowController top = jpfStack.peek().getPageFlow();
            return top;
        }
        return null;
    }

    public static final PageFlowController getCurrentPageFlow(HttpServletRequest request) {
        ActionResolver cur = PageFlowUtils.getCurrentActionResolver(request);
        return cur != null && cur.isPageFlow() ? (PageFlowController)cur : null;
    }

    public static ActionResolver getCurrentActionResolver(HttpServletRequest request) {
        HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
        String currentLongLivedModulePath = (String)ScopedServletUtils.getScopedSessionAttr((String)"_netui:curLongLivedModule", (HttpServletRequest)unwrappedRequest);
        ActionResolver retVal = currentLongLivedModulePath != null ? PageFlowUtils.getLongLivedPageFlow(currentLongLivedModulePath, unwrappedRequest) : (ActionResolver)ScopedServletUtils.getScopedSessionAttr((String)"_netui:curPageFlow", (HttpServletRequest)unwrappedRequest);
        return retVal;
    }

    public static GlobalApp getGlobalApp(HttpServletRequest request) {
        SharedFlowController sf = PageFlowUtils.getSharedFlow("global.Global", request);
        return sf instanceof GlobalApp ? (GlobalApp)sf : null;
    }

    public static Map<String, SharedFlowController> getSharedFlows(HttpServletRequest request) {
        Map sharedFlows = ImplicitObjectUtil.getSharedFlow((ServletRequest)request);
        return sharedFlows != null ? sharedFlows : Collections.EMPTY_MAP;
    }

    public static SharedFlowController getSharedFlow(String sharedFlowClassName, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (SharedFlowController)session.getAttribute("_netui:sharedFlow:" + sharedFlowClassName);
        }
        return null;
    }

    public static void deleteGlobalApp(HttpServletRequest request) {
        PageFlowUtils.deleteSharedFlow("global.Global", request);
    }

    public static void deleteSharedFlow(String sharedFlowClassName, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            request.getSession().removeAttribute("_netui:sharedFlow:" + sharedFlowClassName);
        }
    }

    public static void deleteLongLivedPageFlow(String modulePath, HttpServletRequest request) {
        HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
        String attrName = InternalUtils.getLongLivedFlowAttr(modulePath);
        ScopedServletUtils.removeScopedSessionAttr((String)attrName, (HttpServletRequest)unwrappedRequest);
        String currentLongLivedModulePath = (String)ScopedServletUtils.getScopedSessionAttr((String)"_netui:curLongLivedModule", (HttpServletRequest)unwrappedRequest);
        if (modulePath.equals(currentLongLivedModulePath)) {
            ScopedServletUtils.removeScopedSessionAttr((String)"_netui:curLongLivedModule", (HttpServletRequest)unwrappedRequest);
        }
    }

    public static PageFlowController getLongLivedPageFlow(String modulePath, HttpServletRequest request) {
        String attr = InternalUtils.getLongLivedFlowAttr(modulePath);
        PageFlowController retVal = (PageFlowController)ScopedServletUtils.getScopedSessionAttr((String)attr, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        return retVal;
    }

    public static void setOutputForms(ActionMapping mapping, Forward fwd, HttpServletRequest request, boolean overwrite) {
        if (fwd == null) {
            return;
        }
        if (mapping != null) {
            PageFlowUtils.setOutputForms(mapping, fwd.getOutputForms(), request, overwrite);
        }
        RequestValues.setForwardedFormBean((ServletRequest)request, fwd.getFirstOutputForm(request));
    }

    public static void setOutputForms(ActionMapping mapping, Forward fwd, HttpServletRequest request) {
        if (fwd == null) {
            return;
        }
        if (mapping != null) {
            PageFlowUtils.setOutputForms(mapping, fwd.getOutputForms(), request);
        }
        RequestValues.setForwardedFormBean((ServletRequest)request, fwd.getFirstOutputForm(request));
    }

    public static void setOutputForms(ActionMapping mapping, ActionForm[] outputForms, HttpServletRequest request) {
        PageFlowUtils.setOutputForms(mapping, outputForms, request, true);
    }

    public static void setOutputForms(ActionMapping mapping, ActionForm[] outputForms, HttpServletRequest request, boolean overwrite) {
        try {
            assert (mapping.getScope() == null || mapping.getScope().equals("request") || mapping.getScope().equals("session")) : mapping.getScope();
            for (int i = 0; i < outputForms.length; ++i) {
                PageFlowUtils.setOutputForm(mapping, outputForms[i], request, overwrite);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error while setting Struts form-beans", (Throwable)e);
        }
    }

    private static String getFormNameFromModuleConfig(String formBeanClassName, ModuleConfig moduleConfig) {
        String modulePrefix = moduleConfig.getPrefix();
        Map<String, String> formNameMap = _formNameMaps.get(modulePrefix);
        if (formNameMap == null) {
            formNameMap = new HashMap<String, String>();
            FormBeanConfig[] formBeans = moduleConfig.findFormBeanConfigs();
            for (int j = 0; j < formBeans.length; ++j) {
                assert (formBeans[j] != null);
                if (formBeans[j] instanceof PageFlowActionFormBean) {
                    formNameMap.put(((PageFlowActionFormBean)formBeans[j]).getActualType(), formBeans[j].getName());
                    continue;
                }
                formNameMap.put(formBeans[j].getType(), formBeans[j].getName());
            }
            _formNameMaps.put(modulePrefix, formNameMap);
        }
        return formNameMap.get(formBeanClassName);
    }

    public static void setOutputForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, boolean overwrite) {
        if (form != null) {
            ModuleConfig moduleConfig = mapping.getModuleConfig();
            Class<?> formClass = InternalUtils.unwrapFormBean(form).getClass();
            String formName = PageFlowUtils.getFormNameFromModuleConfig(formClass.getName(), moduleConfig);
            if (formName == null) {
                formName = PageFlowUtils.getFormBeanName(formClass, request, false);
            }
            InternalUtils.setFormInScope(formName, form, mapping, request, overwrite);
        }
    }

    public static String getFormBeanName(ActionForm formInstance, HttpServletRequest request) {
        return PageFlowUtils.getFormBeanName(formInstance, request, true);
    }

    public static String getFormBeanName(Class formBeanClass, HttpServletRequest request) {
        return PageFlowUtils.getFormBeanName(formBeanClass, request, true);
    }

    private static String getFormBeanName(Class formBeanClass, HttpServletRequest request, boolean doStrutsLookup) {
        String name;
        ModuleConfig moduleConfig = RequestUtils.getRequestModuleConfig((HttpServletRequest)request);
        String formBeanClassName = formBeanClass.getName();
        if (doStrutsLookup && (name = PageFlowUtils.getFormNameFromModuleConfig(formBeanClassName, moduleConfig)) != null) {
            return name;
        }
        String formType = formBeanClassName;
        int lastQualifier = formType.lastIndexOf(36);
        if (lastQualifier == -1) {
            lastQualifier = formType.lastIndexOf(46);
        }
        String formName = formType.substring(lastQualifier + 1);
        if (moduleConfig.findFormBeanConfig(formName = Character.toLowerCase(formName.charAt(0)) + formName.substring(1)) != null) {
            formName = formType.replace('.', '_').replace('$', '_');
            assert (moduleConfig.findFormBeanConfig(formName) == null) : formName;
        }
        return formName;
    }

    private static String getFormBeanName(ActionForm formInstance, HttpServletRequest request, boolean doStrutsLookup) {
        return PageFlowUtils.getFormBeanName(formInstance.getClass(), request, doStrutsLookup);
    }

    public static String getPageFlowClassName(String uri) {
        assert (uri != null);
        assert (uri.length() > 0);
        if (uri.charAt(0) == '/') {
            uri = uri.substring(1);
        }
        assert (FileUtils.osSensitiveEndsWith((String)uri, (String)".jpf")) : uri;
        if (FileUtils.osSensitiveEndsWith((String)uri, (String)".jpf")) {
            uri = uri.substring(0, uri.length() - JPF_EXTENSION_LEN);
        }
        return uri.replace('/', '.');
    }

    public static String getJpfClassName(String uri) {
        return PageFlowUtils.getPageFlowClassName(uri);
    }

    public static String getPageFlowURI(String className) {
        return '/' + className.replace('.', '/') + ".jpf";
    }

    public static String getModuleConfPath(String modulePath) {
        return new PageFlowActionServlet.DefaultModuleConfigLocator().getModuleConfigPath(modulePath);
    }

    public static String getActionURI(ServletRequest request) {
        return (String)request.getAttribute(ACTION_URI_ATTR);
    }

    static void setActionURI(HttpServletRequest request) {
        request.setAttribute(ACTION_URI_ATTR, (Object)InternalUtils.getDecodedURI(request));
    }

    public static SecurityProtocol getSecurityProtocol(String uri, ServletContext servletContext, HttpServletRequest request) {
        return ServerAdapterManager.getServerAdapter(servletContext).getSecurityProtocol(uri, request);
    }

    public static Boolean isSecureResource(String uri, ServletContext context) {
        return null;
    }

    public static void addPageInput(String name, Object value, ServletRequest request) {
        PageFlowUtils.addActionOutput(name, value, request);
    }

    public static void addActionOutput(String name, Object value, ServletRequest request) {
        Map map = InternalUtils.getActionOutputMap(request, true);
        if (map.containsKey(name) && _log.isWarnEnabled()) {
            _log.warn((Object)("Overwriting action output\"" + name + "\"."));
        }
        map.put(name, value);
    }

    public static Object getPageInput(String name, ServletRequest request) {
        return PageFlowUtils.getActionOutput(name, request);
    }

    public static Object getActionOutput(String name, ServletRequest request) {
        Map map = InternalUtils.getActionOutputMap(request, false);
        return map != null ? map.get(name) : null;
    }

    public static void addValidationError(String propertyName, String messageKey, Object[] messageArgs, ServletRequest request) {
        InternalUtils.addValidationError(propertyName, new ActionError(messageKey, messageArgs), request);
    }

    public static void addValidationError(String propertyName, String messageKey, Object messageArg, ServletRequest request) {
        InternalUtils.addValidationError(propertyName, new ActionError(messageKey, messageArg), request);
    }

    public static void addValidationError(String propertyName, String messageKey, ServletRequest request) {
        InternalUtils.addValidationError(propertyName, new ActionError(messageKey), request);
    }

    public static ActionResult strutsLookup(ServletContext context, ServletRequest request, HttpServletResponse response, String actionOverride, String[] autoResolveExtensions) throws Exception {
        String returnURI;
        ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)request);
        ScopedResponse scopedResponse = ScopedServletUtils.unwrapResponse((ServletResponse)response);
        assert (scopedRequest != null) : request.getClass().getName();
        assert (scopedResponse != null) : response.getClass().getName();
        if (scopedRequest == null) {
            throw new IllegalStateException("request must be of type " + ScopedRequest.class.getName());
        }
        if (scopedResponse == null) {
            throw new IllegalStateException("response must be of type " + ScopedResponse.class.getName());
        }
        ActionServlet as = InternalUtils.getActionServlet(context);
        if (as == null) {
            _log.error((Object)"There is no initialized ActionServlet.  The ActionServlet must be set to load-on-startup.");
            return null;
        }
        if (actionOverride != null) {
            assert (actionOverride.charAt(0) == '/') : actionOverride;
            StringBuilder uri = new StringBuilder(scopedRequest.getContextPath());
            uri.append(actionOverride);
            uri.append(".do");
            scopedRequest.setRequestURI(uri.toString());
        }
        assert (request instanceof ScopedRequestImpl) : request.getClass().getName();
        ((ScopedRequestImpl)request).setForwardedURI(null);
        as.doGet((HttpServletRequest)scopedRequest, (HttpServletResponse)scopedResponse);
        if (!scopedResponse.didRedirect()) {
            returnURI = scopedRequest.getForwardedURI();
            if (autoResolveExtensions == null) {
                autoResolveExtensions = DEFAULT_AUTORESOLVE_EXTENSIONS;
            }
            if (returnURI != null) {
                for (int i = 0; i < autoResolveExtensions.length; ++i) {
                    if (!FileUtils.uriEndsWith((String)returnURI, (String)autoResolveExtensions[i])) continue;
                    scopedRequest.doForward();
                    return PageFlowUtils.strutsLookup(context, (ServletRequest)scopedRequest, (HttpServletResponse)scopedResponse, null, autoResolveExtensions);
                }
            }
        } else {
            returnURI = scopedResponse.getRedirectURI();
        }
        if (returnURI != null) {
            return new ActionResultImpl(returnURI, scopedResponse.didRedirect(), scopedResponse.getStatusCode(), scopedResponse.getStatusMessage(), scopedResponse.isError());
        }
        return null;
    }

    public static HttpServletRequest unwrapMultipart(HttpServletRequest request) {
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        return request;
    }

    public static GlobalApp ensureGlobalApp(HttpServletRequest request, HttpServletResponse response) {
        ServletContext servletContext = InternalUtils.getServletContext(request);
        return PageFlowUtils.ensureGlobalApp(request, response, servletContext);
    }

    public static GlobalApp ensureGlobalApp(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        Map<String, SharedFlowController> sf = FlowControllerFactory.getSharedFlowsForRequest(request, response, servletContext);
        return PageFlowUtils.getGlobalApp(request);
    }

    public static Map getBindingUpdateErrors(ServletRequest request) {
        return InternalUtils.getBindingUpdateErrors(request);
    }

    public static ModuleConfig ensureModuleConfig(String modulePath, ServletRequest request, ServletContext context) {
        return InternalUtils.ensureModuleConfig(modulePath, request, context);
    }

    public static ModuleConfig getGlobalAppConfig(ServletContext servletContext) {
        return InternalUtils.getModuleConfig("/-global", servletContext);
    }

    public static ModuleConfig getModuleConfig(String modulePath, ServletContext context) {
        return InternalUtils.getModuleConfig(modulePath, context);
    }

    public static String getFileExtension(String filename) {
        return FileUtils.getFileExtension((String)filename);
    }

    public static String getPageFlowClassName(String modulePath, ServletRequest request, ServletContext context) {
        return InternalUtils.getFlowControllerClassName(modulePath, request, context);
    }

    public static boolean ensureAppDeployment(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        return false;
    }

    public static boolean isAbsoluteURI(String uri) {
        return FileUtils.isAbsoluteURI((String)uri);
    }

    public static final PageFlowController ensureCurrentPageFlow(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        return FlowControllerFactory.getPageFlowForRequest(request, response, servletContext);
    }

    public static final PageFlowController ensureCurrentPageFlow(HttpServletRequest request, HttpServletResponse response) {
        ServletContext servletContext = InternalUtils.getServletContext(request);
        if (servletContext == null && _log.isWarnEnabled()) {
            _log.warn((Object)("could not get ServletContext from request " + request));
        }
        return FlowControllerFactory.getPageFlowForRequest(request, response, servletContext);
    }

    public static void addBindingUpdateError(ServletRequest request, String expression, String message, Throwable e) {
        InternalUtils.addBindingUpdateError(request, expression, message, e);
    }

    public static void dumpRequest(HttpServletRequest request, PrintStream output) {
        InternalUtils.dumpRequest(request, output);
    }

    public static void dumpServletContext(ServletContext context, PrintStream output) {
        InternalUtils.dumpServletContext(context, output);
    }

    public static void preventCache(HttpServletResponse response) {
        ServletUtils.preventCache((HttpServletResponse)response);
    }

    public static void setCurrentActionResolver(ActionResolver resolver, HttpServletRequest request) {
        InternalUtils.setCurrentActionResolver(resolver, request);
    }

    public static MutableURI getActionURI(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String actionName) throws URISyntaxException {
        String qualifiedAction = InternalUtils.qualifyAction(servletContext, actionName);
        String actionUrl = InternalUtils.createActionURL(request, qualifiedAction);
        MutableURI uri = new MutableURI(actionUrl);
        uri.setEncoding(response.getCharacterEncoding());
        return uri;
    }

    public static String getRewrittenActionURI(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String actionName, Map params, String fragment, boolean asValidXml) throws URISyntaxException {
        String qualifiedAction = InternalUtils.qualifyAction(servletContext, actionName);
        String actionUrl = InternalUtils.createActionURL(request, qualifiedAction);
        MutableURI uri = new MutableURI(actionUrl);
        uri.setEncoding(response.getCharacterEncoding());
        if (params != null) {
            uri.addParameters(params, false);
        }
        if (fragment != null) {
            uri.setFragment(fragment);
        }
        boolean needsToBeSecure = PageFlowUtils.needsToBeSecure(servletContext, (ServletRequest)request, actionUrl, true);
        URLRewriterService.rewriteURL((ServletContext)servletContext, (ServletRequest)request, (ServletResponse)response, (MutableURI)uri, (URLRewriter.URLType)URLRewriter.URLType.ACTION, (boolean)needsToBeSecure);
        if (asValidXml) {
            return uri.toXMLString();
        }
        return uri.toString();
    }

    public static String getRewrittenResourceURI(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Map params, String fragment, boolean asValidXml) throws URISyntaxException {
        MutableURI uri = new MutableURI(path);
        uri.setEncoding(response.getCharacterEncoding());
        if (params != null) {
            uri.addParameters(params, false);
        }
        if (fragment != null) {
            uri.setFragment(fragment);
        }
        if (!uri.isAbsolute()) {
            if (!path.startsWith("/") && !path.equals("")) {
                String reqUri = request.getRequestURI();
                String reqPath = reqUri.substring(0, reqUri.lastIndexOf(47) + 1);
                uri.setPath(reqPath + uri.getPath());
            }
            boolean needsToBeSecure = PageFlowUtils.needsToBeSecure(servletContext, (ServletRequest)request, uri.getPath(), true);
            URLRewriterService.rewriteURL((ServletContext)servletContext, (ServletRequest)request, (ServletResponse)response, (MutableURI)uri, (URLRewriter.URLType)URLRewriter.URLType.RESOURCE, (boolean)needsToBeSecure);
        }
        if (asValidXml) {
            return uri.toXMLString();
        }
        return uri.toString();
    }

    public static boolean needsToBeSecure(ServletContext context, ServletRequest request, String uri, boolean stripContextPath) {
        SecurityProtocol sp;
        String contextPath;
        String secureCheck = uri;
        if (stripContextPath && secureCheck.startsWith(contextPath = ((HttpServletRequest)request).getContextPath())) {
            secureCheck = secureCheck.substring(contextPath.length());
        }
        boolean secure = false;
        if (secureCheck.indexOf(63) > -1) {
            secureCheck = secureCheck.substring(0, secureCheck.indexOf(63));
        }
        secure = (sp = PageFlowUtils.getSecurityProtocol(secureCheck, context, (HttpServletRequest)request)).equals((Object)SecurityProtocol.UNSPECIFIED) ? request.isSecure() : sp.equals((Object)SecurityProtocol.SECURE);
        return secure;
    }
}

