/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.PageFlowManagedObject;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.util.Bundle;

public abstract class PageFlowManagedObjectException
extends RuntimeException {
    private PageFlowManagedObject _managedObject;
    private String _messageKeyPrefix;

    protected PageFlowManagedObjectException(PageFlowManagedObject object) {
        this.init(object);
    }

    protected PageFlowManagedObjectException(PageFlowManagedObject object, Throwable cause) {
        super(cause);
        this.init(object);
    }

    protected void init(PageFlowManagedObject object) {
        this._managedObject = object;
        String className = this.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        assert (lastDot != -1);
        this._messageKeyPrefix = "PageFlow_" + className.substring(lastDot + 1);
    }

    public PageFlowManagedObject getManagedObject() {
        return this._managedObject;
    }

    protected void setManagedObject(PageFlowManagedObject managedObject) {
        this._managedObject = managedObject;
    }

    void sendError(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, int productionTimeErrorCode) throws IOException {
        InternalUtils.sendDevTimeError(this._messageKeyPrefix, this.getMessageArgs(), null, productionTimeErrorCode, request, response, servletContext);
    }

    public void sendError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InternalUtils.sendError(this._messageKeyPrefix, this.getMessageArgs(), request, response, null);
    }

    public void printError(PrintWriter writer) {
        writer.println(Bundle.getString((String)(this._messageKeyPrefix + "_Page"), (Object[])this.getMessageArgs()));
    }

    public String getLocalizedMessage() {
        return Bundle.getString((String)(this._messageKeyPrefix + "_Message"), (Object[])this.getMessageArgs());
    }

    public String getMessage() {
        StringBuilder buf = new StringBuilder();
        String[] parts = this.getMessageParts();
        Object[] args = this.getMessageArgs();
        assert (parts.length > args.length) : parts.length + ", " + args.length;
        for (int i = 0; i < parts.length; ++i) {
            buf.append(parts[i]);
            if (i >= args.length) continue;
            buf.append(args[i]);
        }
        return buf.toString();
    }

    protected abstract Object[] getMessageArgs();

    protected abstract String[] getMessageParts();
}

