/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.beehive.controls.api.bean.ControlBean;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.properties.PropertyMap;
import org.apache.beehive.netui.pageflow.ControlFieldInitializationException;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.internal.JavaControlUtils;
import org.apache.beehive.netui.util.logging.Logger;

public abstract class PageFlowManagedObject
implements Serializable,
HttpSessionBindingListener {
    private static final Logger _log = Logger.getInstance(PageFlowManagedObject.class);
    private transient ServletContext _servletContext;

    public void reinitialize(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public synchronized void create(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws Exception {
        this.reinitialize(request, response, servletContext);
        this.initJavaControls(request, response);
        this.onCreate();
    }

    void destroy(HttpSession session) {
        this.onDestroy(session);
        this.uninitJavaControls();
    }

    protected void onCreate() throws Exception {
    }

    protected void onDestroy(HttpSession session) {
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.destroy(event.getSession());
    }

    protected abstract void deleteFromSession(HttpServletRequest var1);

    public abstract void persistInSession(HttpServletRequest var1, HttpServletResponse var2);

    public abstract void ensureFailover(HttpServletRequest var1);

    private void initJavaControls(HttpServletRequest request, HttpServletResponse response) throws ControlFieldInitializationException {
        Map controlFields = JavaControlUtils.getAccessibleControlFieldAnnotations(this.getClass());
        if (controlFields.isEmpty()) {
            return;
        }
        request = PageFlowUtils.unwrapMultipart(request);
        ControlBeanContext beanContext = JavaControlUtils.getControlBeanContext(request, response, this._servletContext, false);
        assert (beanContext != null) : "ControlBeanContext was not initialized by PageFlowRequestProcessor";
        String classID = this.getClass().getName();
        for (Map.Entry entry : controlFields.entrySet()) {
            Field field = (Field)entry.getKey();
            assert (!Modifier.isTransient(field.getModifiers())) : field.getName();
            try {
                if (field.get(this) != null) continue;
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("Initializing field " + field.getName() + " (" + field.getType().getName() + ") with a Java Control..."));
                }
                PropertyMap propertyMap = (PropertyMap)entry.getValue();
                Class<?> fieldType = field.getType();
                String controlID = this.getControlID(field, classID);
                boolean isControlBeanClass = !fieldType.isInterface();
                ControlBean bean = JavaControlUtils.createControl(fieldType.getName(), isControlBeanClass, controlID, propertyMap, beanContext);
                field.set(this, bean);
            }
            catch (Exception e) {
                _log.error((Object)("Exception occurred while initializing control field " + field.getName()), (Throwable)e);
                throw new ControlFieldInitializationException(field.getName(), this, e);
            }
        }
    }

    private String getControlID(Field controlField, String classID) {
        StringBuilder controlID = new StringBuilder();
        controlID.append(classID);
        controlID.append('@').append(this.hashCode());
        controlID.append('.').append(controlField.getName());
        return controlID.toString();
    }

    private void uninitJavaControls() {
        Map controlFields = JavaControlUtils.getAccessibleControlFieldAnnotations(this.getClass());
        for (Field controlField : controlFields.keySet()) {
            try {
                Object fieldValue = controlField.get(this);
                if (fieldValue == null) continue;
                controlField.set(this, null);
                JavaControlUtils.destroyControl(fieldValue);
            }
            catch (IllegalAccessException e) {
                _log.error((Object)("Exception while uninitializing Java Control " + controlField.getName()), (Throwable)e);
            }
        }
    }

    protected ServletContext getServletContext() {
        return this._servletContext;
    }

    public abstract String getDisplayName();

    protected boolean fieldIsUninitialized(Field field) {
        try {
            return field != null && field.get(this) == null;
        }
        catch (IllegalAccessException e) {
            _log.error((Object)("Error initializing field " + field.getName() + " in " + this.getDisplayName()), (Throwable)e);
            return false;
        }
    }

    protected void initializeField(Field field, Object instance) {
        if (instance != null) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Initializing field " + field.getName() + " in " + this.getDisplayName() + " with " + instance));
            }
            try {
                field.set(this, instance);
            }
            catch (IllegalArgumentException e) {
                _log.error((Object)("Could not set field " + field.getName() + " on " + this.getDisplayName() + "; instance is of type " + instance.getClass().getName() + ", field type is " + field.getType().getName()));
            }
            catch (IllegalAccessException e) {
                _log.error((Object)("Error initializing field " + field.getName() + " in " + this.getDisplayName()), (Throwable)e);
            }
        }
    }
}

