/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.FlowControllerFactory;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.PreviousActionInfo;
import org.apache.beehive.netui.pageflow.PreviousPageInfo;
import org.apache.beehive.netui.pageflow.ServerAdapter;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.config.PageFlowControllerConfig;
import org.apache.beehive.netui.pageflow.internal.CachedPageFlowInfo;
import org.apache.beehive.netui.pageflow.internal.CachedSharedFlowRefInfo;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.RequestValues;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.internal.ViewRenderer;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.util.DiscoveryUtils;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.cache.ClassLevelCache;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageFlowController
extends FlowController {
    private PreviousPageInfo _previousPageInfo = null;
    private PreviousPageInfo _currentPageInfo = null;
    private PreviousActionInfo _previousActionInfo;
    private boolean _isOnNestingStack = false;
    private ViewRenderer _returnActionViewRenderer = null;
    private static final String DELETING_PAGEFLOW_ATTR = "_netui:deletingPageFlow";
    private static final String CACHED_INFO_KEY = "cachedInfo";
    private static final Logger _log = Logger.getInstance(PageFlowController.class);

    protected PageFlowController() {
    }

    @Override
    public String getModulePath() {
        return this.getCachedInfo().getModulePath();
    }

    @Override
    public String getURI() {
        return this.getCachedInfo().getURI();
    }

    @Override
    protected boolean isNestable() {
        return InternalUtils.isNestable(this.getModuleConfig());
    }

    @Override
    protected boolean isLongLived() {
        return InternalUtils.isLongLived(this.getModuleConfig());
    }

    @Override
    protected synchronized void deleteFromSession(HttpServletRequest request) {
        request.setAttribute(DELETING_PAGEFLOW_ATTR, (Object)this);
        if (this.isLongLived()) {
            PageFlowUtils.deleteLongLivedPageFlow(this.getModulePath(), request);
        } else {
            InternalUtils.deleteCurrentPageFlow(request);
        }
    }

    @Override
    public boolean isPageFlow() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistInSession(HttpServletRequest request, HttpServletResponse response) {
        PageFlowController currentPageFlow = PageFlowUtils.getCurrentPageFlow(request);
        if (currentPageFlow != null && !currentPageFlow.isOnNestingStack()) {
            PageFlowController pageFlowController = currentPageFlow;
            synchronized (pageFlowController) {
                InternalUtils.setCurrentPageFlow(this, request);
            }
        } else {
            InternalUtils.setCurrentPageFlow(this, request);
        }
    }

    @Override
    public void ensureFailover(HttpServletRequest request) {
        if (request.getAttribute(DELETING_PAGEFLOW_ATTR) != this && request.getSession(false) != null) {
            HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
            ServerAdapter serverAdapter = ServerAdapterManager.getServerAdapter(this.getServletContext());
            if (this.isLongLived()) {
                String longLivedAttrName = InternalUtils.getLongLivedFlowAttr(this.getModulePath());
                longLivedAttrName = ScopedServletUtils.getScopedSessionAttrName((String)longLivedAttrName, (HttpServletRequest)unwrappedRequest);
                String currentLongLivedAttrName = ScopedServletUtils.getScopedSessionAttrName((String)"_netui:curLongLivedModule", (HttpServletRequest)unwrappedRequest);
                serverAdapter.ensureFailover(longLivedAttrName, this, unwrappedRequest);
                serverAdapter.ensureFailover(currentLongLivedAttrName, this.getModulePath(), unwrappedRequest);
            } else {
                String attrName = ScopedServletUtils.getScopedSessionAttrName((String)"_netui:curPageFlow", (HttpServletRequest)unwrappedRequest);
                serverAdapter.ensureFailover(attrName, this, unwrappedRequest);
            }
        }
    }

    @Override
    protected ActionForward internalExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initializeSharedFlowFields(request);
        return super.internalExecute(mapping, form, request, response);
    }

    private void initializeSharedFlowFields(HttpServletRequest request) {
        CachedSharedFlowRefInfo.SharedFlowFieldInfo[] sharedFlowMemberFields = this.getCachedInfo().getSharedFlowMemberFields();
        if (sharedFlowMemberFields != null) {
            for (int i = 0; i < sharedFlowMemberFields.length; ++i) {
                GlobalApp sf;
                CachedSharedFlowRefInfo.SharedFlowFieldInfo fi = sharedFlowMemberFields[i];
                Field field = fi.field;
                if (!this.fieldIsUninitialized(field)) continue;
                Map<String, SharedFlowController> sharedFlows = PageFlowUtils.getSharedFlows(request);
                String name = fi.sharedFlowName;
                SharedFlowController sharedFlowController = sf = name != null ? sharedFlows.get(name) : PageFlowUtils.getGlobalApp(request);
                if (sf != null) {
                    this.initializeField(field, sf);
                    continue;
                }
                _log.error((Object)("Could not find shared flow with name \"" + fi.sharedFlowName + "\" to initialize field " + field.getName() + " in " + this.getClass().getName()));
            }
        }
    }

    public Map<String, SharedFlowController> getSharedFlows() {
        return PageFlowUtils.getSharedFlows(this.getRequest());
    }

    @Override
    public final synchronized void create(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        ViewRenderer vr;
        String vrClassName;
        this.reinitialize(request, response, servletContext);
        this.initializeSharedFlowFields(request);
        if (this.isNestable() && (vrClassName = request.getParameter("_netui:returnActionViewRenderer")) != null && (vr = (ViewRenderer)DiscoveryUtils.newImplementorInstance((String)vrClassName, ViewRenderer.class)) != null) {
            vr.init((ServletRequest)request);
            this._returnActionViewRenderer = vr;
        }
        super.create(request, response, servletContext);
    }

    protected String getTaxonomy() {
        assert (this.getRequest() != null) : "this method can only be called during execute()";
        String contextPath = this.getRequest().getContextPath();
        assert (contextPath.startsWith("/")) : contextPath;
        return contextPath.substring(1) + '.' + this.getClass().getName();
    }

    protected ActionForm getPreviousForm() {
        this.checkPreviousActionInfoDisabled();
        return this._previousActionInfo != null ? this._previousActionInfo.getForm() : null;
    }

    protected Object getPreviousFormBean() {
        this.checkPreviousActionInfoDisabled();
        return this._previousActionInfo != null ? InternalUtils.unwrapFormBean(this._previousActionInfo.getForm()) : null;
    }

    protected String getPreviousActionURI() {
        this.checkPreviousActionInfoDisabled();
        return this._previousActionInfo != null ? this._previousActionInfo.getActionURI() : null;
    }

    protected String getCurrentForwardPath() {
        ActionForward curForward;
        PreviousPageInfo curPageInfo = this.getCurrentPageInfo();
        String path = null;
        if (curPageInfo != null && (curForward = curPageInfo.getForward()) != null) {
            path = curForward.getContextRelative() ? curForward.getPath() : this.getModulePath() + curForward.getPath();
        }
        return path;
    }

    protected String getPreviousForwardPath() {
        PreviousPageInfo prevPageInfo = this.getPreviousPageInfo();
        if (prevPageInfo != null) {
            ActionForward prevForward = prevPageInfo.getForward();
            return prevForward != null ? prevForward.getPath() : null;
        }
        return null;
    }

    @Override
    final PreviousPageInfo getPreviousPageInfoLegacy(PageFlowController curJpf, HttpServletRequest request) {
        if (request.getAttribute("_netui:nestedReturning") != null) {
            return this.getCurrentPageInfo();
        }
        return this.getPreviousPageInfo();
    }

    public final PreviousPageInfo getCurrentPageInfo() {
        this.checkPreviousPageInfoDisabled();
        if (this._currentPageInfo != null) {
            this._currentPageInfo.reinitialize(this);
        }
        return this._currentPageInfo;
    }

    public final PreviousPageInfo getPreviousPageInfo() {
        PreviousPageInfo ret;
        this.checkPreviousPageInfoDisabled();
        PreviousPageInfo previousPageInfo = ret = this._previousPageInfo != null ? this._previousPageInfo : this._currentPageInfo;
        if (ret != null) {
            ret.reinitialize(this);
        }
        return ret;
    }

    public final PreviousActionInfo getPreviousActionInfo() {
        this.checkPreviousActionInfoDisabled();
        return this._previousActionInfo;
    }

    private void checkPreviousActionInfoDisabled() {
        if (this.isPreviousActionInfoDisabled()) {
            throw new IllegalStateException("Previous action information has been disabled in this page flow.  Override alwaysTrackPreviousAction() to enable it.");
        }
    }

    private void checkPreviousPageInfoDisabled() {
        if (this.isPreviousPageInfoDisabled()) {
            throw new IllegalStateException("Previous page information has been disabled in this page flow.  Override alwaysTrackPreviousPage() to enable it.");
        }
    }

    @Override
    public String getDisplayName() {
        return this.getURI();
    }

    private boolean isPreviousActionInfoDisabled() {
        if (this.alwaysTrackPreviousAction()) {
            return false;
        }
        ModuleConfig mc = this.getModuleConfig();
        ControllerConfig cc = mc.getControllerConfig();
        return cc instanceof PageFlowControllerConfig && ((PageFlowControllerConfig)cc).isReturnToActionDisabled();
    }

    private boolean isPreviousPageInfoDisabled() {
        if (this.alwaysTrackPreviousPage()) {
            return false;
        }
        ModuleConfig mc = this.getModuleConfig();
        ControllerConfig cc = mc.getControllerConfig();
        return cc instanceof PageFlowControllerConfig && ((PageFlowControllerConfig)cc).isReturnToPageDisabled();
    }

    @Override
    void savePreviousActionInfo(ActionForm form, HttpServletRequest request, ActionMapping mapping, ServletContext servletContext) {
        if (this.isPreviousActionInfoDisabled()) {
            return;
        }
        String actionURI = PageFlowUtils.getRelativeURI(request, null);
        this._previousActionInfo = new PreviousActionInfo(form, actionURI, request.getQueryString());
    }

    @Override
    void savePreviousPageInfo(ActionForward forward, ActionForm form, ActionMapping mapping, HttpServletRequest request, ServletContext servletContext, boolean isSpecialForward) {
        if (this.isPreviousPageInfoDisabled()) {
            return;
        }
        if (forward != null) {
            ActionForm oldForm;
            String path = forward.getPath();
            int queryPos = path.indexOf(63);
            if (queryPos != -1) {
                path = path.substring(0, queryPos);
            }
            if (form != null && this._currentPageInfo != null && ((oldForm = this._currentPageInfo.getForm()) == null || oldForm.getClass().equals(form.getClass()))) {
                this._currentPageInfo.setForm(form);
                this._currentPageInfo.setMapping(mapping);
            }
            if (!FileUtils.osSensitiveEndsWith((String)path, (String)".do") && this.isLocalFile(forward)) {
                this._previousPageInfo = this._currentPageInfo;
                this._currentPageInfo = new PreviousPageInfo(forward, form, mapping);
            }
        }
    }

    private boolean isLocalFile(ActionForward forward) {
        String path = forward.getPath();
        if (!forward.getContextRelative()) {
            return path.indexOf(47, 1) == -1;
        }
        String modulePath = this.getModulePath();
        if (!path.startsWith(modulePath)) {
            return false;
        }
        return path.indexOf(47, modulePath.length() + 1) == -1;
    }

    private boolean isOnNestingStack() {
        return this._isOnNestingStack;
    }

    @Override
    public void valueUnbound(HttpSessionBindingEvent event) {
        if (!this._isOnNestingStack) {
            this.destroy(event.getSession());
        }
    }

    void setIsOnNestingStack(boolean isOnNestingStack) {
        this._isOnNestingStack = isOnNestingStack;
    }

    @Override
    ActionForward forwardTo(ActionForward fwd, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String actionName, ModuleConfig altModuleConfig, ActionForm form, ServletContext servletContext) {
        ActionForward superFwd = super.forwardTo(fwd, mapping, request, response, actionName, altModuleConfig, form, servletContext);
        if (superFwd != null && InternalUtils.isNestable(this.getModuleConfig())) {
            boolean selfNesting = false;
            if (superFwd.getContextRelative()) {
                if (superFwd.getPath().equals(this.getURI())) {
                    selfNesting = true;
                }
            } else if (superFwd.getPath().equals(this.getStrutsLocalURI())) {
                selfNesting = true;
            }
            if (selfNesting) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Self-nesting page flow " + this.getURI()));
                }
                FlowControllerFactory.getPageFlow(this.getClass(), request, response, this.getServletContext());
            }
        }
        return superFwd;
    }

    private String getStrutsLocalURI() {
        String className = this.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        StringBuilder ret = new StringBuilder("/");
        return ret.append(className.substring(lastDot + 1)).append(".jpf").toString();
    }

    private CachedPageFlowInfo getCachedInfo() {
        ClassLevelCache cache = ClassLevelCache.getCache(this.getClass());
        CachedPageFlowInfo info = (CachedPageFlowInfo)cache.getCacheObject(CACHED_INFO_KEY);
        if (info == null) {
            info = new CachedPageFlowInfo(this.getClass());
            cache.setCacheObject(CACHED_INFO_KEY, (Object)info);
        }
        return info;
    }

    final void beforePage() {
        if (!this.isPreviousPageInfoDisabled()) {
            HttpServletRequest request = this.getRequest();
            String relativeUri = PageFlowUtils.getRelativeURI(request, null);
            String path = this.getCurrentForwardPath();
            if (path == null || !path.equals(relativeUri)) {
                ActionForward actionForward = new ActionForward(relativeUri);
                actionForward.setContextRelative(true);
                actionForward.setRedirect(false);
                this.savePreviousPageInfo(actionForward, null, null, request, this.getServletContext(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionForward exitNesting(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, ActionForm form) {
        if (this._returnActionViewRenderer != null) {
            RequestValues.setViewRenderer((ServletRequest)request, this._returnActionViewRenderer);
        }
        FlowController.PerRequestState prevState = this.setPerRequestState(new FlowController.PerRequestState(request, response, mapping));
        try {
            this.onExitNesting();
        }
        catch (Throwable th) {
            try {
                ActionForward actionForward = this.handleException(th, mapping, form, request, response);
                return actionForward;
            }
            catch (Exception e) {
                _log.error((Object)"Exception thrown while handling exception in onExitNesting()", (Throwable)e);
            }
        }
        finally {
            this.setPerRequestState(prevState);
        }
        return null;
    }

    protected void onExitNesting() throws Exception {
    }
}

