/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.util.UrlTemplateDescriptor;
import org.apache.beehive.netui.util.config.ConfigInitializationException;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.logging.Logger;

public class PageFlowContextListener
implements ServletContextListener {
    private static final String ALREADY_INIT_ATTR = "_netui:contextInit";
    private static final Logger _log = Logger.getInstance(PageFlowContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        PageFlowContextListener.performInitializations(event.getServletContext());
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    static boolean isInit(ServletContext servletContext) {
        return servletContext.getAttribute(ALREADY_INIT_ATTR) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performInitializations(ServletContext servletContext) {
        servletContext.setAttribute(ALREADY_INIT_ATTR, (Object)Boolean.TRUE);
        try {
            InputStream configInput = servletContext.getResourceAsStream("/WEB-INF/netui-config.xml");
            try {
                ConfigUtil.init((InputStream)configInput);
            }
            finally {
                block11: {
                    try {
                        if (configInput != null) {
                            configInput.close();
                        }
                    }
                    catch (IOException e) {
                        if (!_log.isErrorEnabled()) break block11;
                        _log.error((Object)"Could not close input for /WEB-INF/netui-config.xml");
                    }
                }
            }
        }
        catch (ConfigInitializationException e) {
            _log.fatal((Object)"Could not initialize from /WEB-INF/netui-config.xml", (Throwable)e);
            throw new IllegalStateException("Could not initialize from /WEB-INF/netui-config.xml", e);
        }
        ContextCache.init(servletContext);
        ServerAdapterManager.init(servletContext);
        UrlTemplateDescriptor.getInstance().load(servletContext);
    }
}

