/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.el.ELException;
import javax.sql.DataSource;
import org.apache.beehive.netui.core.urls.MutableURI;
import org.apache.beehive.netui.pageflow.ActionNotFoundException;
import org.apache.beehive.netui.pageflow.ActionResolver;
import org.apache.beehive.netui.pageflow.ActionResult;
import org.apache.beehive.netui.pageflow.AutoRegisterActionServlet;
import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.ForwardHandler;
import org.apache.beehive.netui.pageflow.LoginExpiredException;
import org.apache.beehive.netui.pageflow.NoMatchingActionMethodException;
import org.apache.beehive.netui.pageflow.NotLoggedInException;
import org.apache.beehive.netui.pageflow.PageFlowConstants;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowException;
import org.apache.beehive.netui.pageflow.PageFlowManagedObject;
import org.apache.beehive.netui.pageflow.PageFlowRequestProcessor;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.PreviousPageInfo;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.beehive.netui.pageflow.config.PageFlowActionMapping;
import org.apache.beehive.netui.pageflow.handler.ExceptionsHandler;
import org.apache.beehive.netui.pageflow.handler.LoginHandler;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.InternalExpressionUtils;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.cache.ClassLevelCache;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.TokenProcessor;

@Jpf.Controller(forwards={@Jpf.Forward(name="_auto", path="")})
public abstract class FlowController
extends PageFlowManagedObject
implements PageFlowConstants,
ActionResolver {
    private static final Logger _log = Logger.getInstance(FlowController.class);
    private static final String ONCREATE_EXCEPTION_FORWARD = "_netui:onCreateException";
    private static final String CACHEID_ACTION_METHODS = "_netui:actionMethods";
    private static final int DEFAULT_MAX_CONCURRENT_REQUEST_COUNT = 4;
    private static final String MAX_CONCURRENT_REQUESTS_PARAM = "pageflow-max-concurrent-requests";
    private static final int EXCEEDED_MAX_CONCURRENT_REQUESTS_ERRORCODE = 503;
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final ActionForward NULL_ACTION_FORWARD = new ActionForward();
    private static final TokenProcessor TOKEN_PROCESSOR = TokenProcessor.getInstance();
    protected static Locale defaultLocale = DEFAULT_LOCALE;
    protected transient ActionServlet servlet = null;
    private transient PerRequestState _perRequestState;
    private transient ModuleConfig _moduleConfig = null;
    private transient int _requestCount = 0;
    private static int _maxConcurrentRequestCount = -1;

    protected FlowController() {
    }

    public void reinitialize(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.initModuleConfig(servletContext, request);
        this.servlet = this.getServlet();
        super.reinitialize(request, response, servletContext);
    }

    public void login(String username, String password) throws LoginException {
        LoginHandler lh = ContextCache.get(this.getServletContext()).getLoginHandler();
        lh.login(username, password, this.getRequest(), this.getResponse());
    }

    public void logout(boolean invalidateSessions) {
        LoginHandler lh = ContextCache.get(this.getServletContext()).getLoginHandler();
        lh.logout(invalidateSessions, this.getRequest(), this.getResponse());
    }

    protected void sendError(String errText, HttpServletResponse response) throws IOException {
        this.sendError(errText, null, response);
    }

    protected void sendError(String errText, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InternalUtils.sendError("PageFlow_Custom_Error", null, request, response, this.getDisplayName(), errText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ActionForward handleException(Throwable ex, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PerRequestState prevState = this.setPerRequestState(new PerRequestState(request, response, mapping));
        try {
            ExceptionsHandler eh = ContextCache.get(this.getServletContext()).getExceptionsHandler();
            Throwable unwrapped = eh.unwrapException(ex);
            eh.exposeException(unwrapped, mapping, request, response, this.getServletContext());
            ActionForward actionForward = eh.handleException(unwrapped, mapping, form, this, request, response, this.getServletContext());
            return actionForward;
        }
        finally {
            this.setPerRequestState(prevState);
        }
    }

    protected String getCurrentActionName() {
        return InternalUtils.getActionName(this.getActionMapping());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.incrementRequestCount(request, response, this.getServletContext())) {
            try {
                FlowController flowController = this;
                synchronized (flowController) {
                    ActionForward actionForward = this.internalExecute(mapping, form, request, response);
                    return actionForward;
                }
            }
            finally {
                this.decrementRequestCount(request);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward internalExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward onCreateFwd = (ActionForward)request.getAttribute(ONCREATE_EXCEPTION_FORWARD);
        if (onCreateFwd != null) {
            return onCreateFwd == NULL_ACTION_FORWARD ? null : onCreateFwd;
        }
        PageFlowUtils.setActionURI(request);
        boolean gotPastBeforeAction = false;
        ServletContext servletContext = this.getServletContext();
        PerRequestState prevState = this.setPerRequestState(new PerRequestState(request, response, mapping));
        try {
            ActionForward actionForward;
            this.beforeAction();
            gotPastBeforeAction = true;
            PageFlowActionMapping pfActionMapping = mapping instanceof PageFlowActionMapping ? (PageFlowActionMapping)mapping : null;
            Object unwrappedForm = InternalUtils.unwrapFormBean(form);
            if (unwrappedForm != null && pfActionMapping != null && pfActionMapping.isOverloaded()) {
                String mappingPath = pfActionMapping.getPath();
                for (Class<?> i = unwrappedForm.getClass(); i != null; i = i.getSuperclass()) {
                    String formQualifiedActionPath = FlowController.getFormQualifiedActionPath(i, mappingPath);
                    ActionConfig cf = pfActionMapping.getModuleConfig().findActionConfig(formQualifiedActionPath);
                    if (cf == null) continue;
                    assert (cf instanceof PageFlowActionMapping) : cf.getClass().getName();
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Found form-specific mapping " + cf.getPath() + " -- choosing this one over current mapping " + mappingPath));
                    }
                    pfActionMapping = (PageFlowActionMapping)cf;
                    mapping = pfActionMapping;
                    break;
                }
            }
            String actionName = InternalUtils.getActionName(mapping);
            LoginHandler loginHandler = ContextCache.get(this.getServletContext()).getLoginHandler();
            if (pfActionMapping != null && pfActionMapping.isLoginRequired() && loginHandler.getUserPrincipal(request) == null) {
                NotLoggedInException ex = this.createNotLoggedInException(actionName, request);
                actionForward = this.handleException(ex, mapping, form, request, response);
                return actionForward;
            }
            ActionForward retVal = pfActionMapping != null && pfActionMapping.isSimpleAction() ? FlowController.handleSimpleAction(pfActionMapping, form, request, servletContext) : this.getActionMethodForward(actionName, unwrappedForm, request, response, mapping);
            actionForward = this.forwardTo(retVal, mapping, request, response, actionName, null, form, servletContext);
            return actionForward;
        }
        catch (Exception e) {
            ActionForward actionForward = this.handleException(e, mapping, form, request, response);
            return actionForward;
        }
        finally {
            try {
                ActionForward overrideReturn = null;
                if (gotPastBeforeAction) {
                    try {
                        this.afterAction();
                    }
                    catch (Throwable th) {
                        overrideReturn = this.handleException(th, mapping, form, request, response);
                    }
                }
                this.savePreviousActionInfo(form, request, mapping, this.getServletContext());
                if (overrideReturn != null) {
                    ActionForward actionForward = overrideReturn;
                    return actionForward;
                }
            }
            finally {
                this.setPerRequestState(prevState);
            }
        }
    }

    ActionForward forwardTo(ActionForward fwd, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String actionName, ModuleConfig altModuleConfig, ActionForm form, ServletContext servletContext) {
        return ForwardHandler.forwardTo(fwd, mapping, request, response, actionName, altModuleConfig, form, servletContext, this);
    }

    NotLoggedInException createNotLoggedInException(String actionName, HttpServletRequest request) {
        if (InternalUtils.sessionExpired(request)) {
            return new LoginExpiredException(actionName, this);
        }
        return new NotLoggedInException(actionName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void create(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        PerRequestState prevState = this.setPerRequestState(new PerRequestState(request, response, null));
        try {
            try {
                super.create(request, response, servletContext);
            }
            catch (Throwable th) {
                try {
                    _log.info((Object)("Handling exception in onCreate(), page flow " + this), th);
                    ActionForward fwd = this.handleException(th, null, null, request, response);
                    if (fwd == null) {
                        fwd = NULL_ACTION_FORWARD;
                    }
                    request.setAttribute(ONCREATE_EXCEPTION_FORWARD, (Object)fwd);
                }
                catch (Exception e) {
                    _log.error((Object)("Exception thrown while handling exception in onCreate(): " + e.getMessage()), th);
                }
            }
        }
        finally {
            this.setPerRequestState(prevState);
        }
    }

    void destroy(HttpSession session) {
        this.onDestroy();
        super.destroy(session);
    }

    public abstract String getModulePath();

    protected synchronized void beforeAction() throws Exception {
    }

    protected synchronized void afterAction() throws Exception {
    }

    protected void onCreate() throws Exception {
    }

    protected void onDestroy() {
    }

    protected void onDestroy(HttpSession session) {
    }

    abstract PreviousPageInfo getPreviousPageInfoLegacy(PageFlowController var1, HttpServletRequest var2);

    protected Method getActionMethod(String methodName, Class argType) {
        String cacheKey = argType != null ? methodName + '/' + argType.getName() : methodName;
        Class<?> thisClass = this.getClass();
        ClassLevelCache cache = ClassLevelCache.getCache(thisClass);
        Method actionMethod = (Method)cache.get(CACHEID_ACTION_METHODS, cacheKey);
        if (actionMethod != null) {
            return actionMethod;
        }
        if (argType == null) {
            actionMethod = InternalUtils.lookupMethod(thisClass, methodName, null);
        } else {
            while (argType != null && (actionMethod = InternalUtils.lookupMethod(thisClass, methodName, new Class[]{argType})) == null) {
                argType = argType.getSuperclass();
            }
        }
        if (actionMethod != null && actionMethod.getReturnType().equals(Forward.class)) {
            actionMethod.setAccessible(true);
            cache.put(CACHEID_ACTION_METHODS, cacheKey, (Object)actionMethod);
            return actionMethod;
        }
        return null;
    }

    private Class getFormClass(Object form, ActionMapping mapping, HttpServletRequest request) throws ClassNotFoundException {
        String formClassName;
        if (mapping instanceof PageFlowActionMapping && (formClassName = ((PageFlowActionMapping)mapping).getFormClass()) != null) {
            return InternalUtils.getReloadableClass(formClassName, request, this.getServletContext());
        }
        return form != null ? form.getClass() : null;
    }

    ActionForward getActionMethodForward(String actionName, Object inputForm, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws Exception {
        Class formClass = this.getFormClass(inputForm, mapping, request);
        Method actionMethod = this.getActionMethod(actionName, formClass);
        if (actionMethod != null) {
            return this.invokeActionMethod(actionMethod, inputForm, request, mapping);
        }
        if (_log.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder("Could not find matching action method for action=");
            msg.append(actionName).append(", form=");
            msg.append(inputForm != null ? inputForm.getClass().getName() : "[none]");
            _log.warn((Object)msg.toString());
        }
        NoMatchingActionMethodException ex = new NoMatchingActionMethodException(actionName, inputForm, this);
        InternalUtils.throwPageFlowException(ex, request);
        return null;
    }

    private static String getFormQualifiedActionPath(Class formClass, String actionPath) {
        StringBuilder ret = new StringBuilder(actionPath);
        ret.append('_');
        ret.append(formClass.getName().replace('.', '_').replace('$', '_'));
        return ret.toString();
    }

    protected ActionForward invokeActionMethod(Method method, Object arg) throws Exception {
        return this.invokeActionMethod(method, arg, this.getRequest(), this.getActionMapping());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionForward invokeActionMethod(Method method, Object arg, HttpServletRequest request, ActionMapping mapping) throws Exception {
        Class<?>[] paramTypes = method.getParameterTypes();
        try {
            if (paramTypes.length > 0 && paramTypes[0].isInstance(arg)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invoking action method " + method.getName() + '(' + paramTypes[0].getName() + ')'));
                }
                ActionForward actionForward = (ActionForward)method.invoke((Object)this, arg);
                return actionForward;
            }
            if (paramTypes.length == 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invoking action method " + method.getName() + "()"));
                }
                ActionForward actionForward = (ActionForward)method.invoke((Object)this, new Object[0]);
                return actionForward;
            }
        }
        finally {
            boolean readonly = false;
            if (mapping instanceof PageFlowActionMapping) {
                PageFlowActionMapping pfam = (PageFlowActionMapping)mapping;
                readonly = pfam.isReadonly();
            }
            if (!readonly) {
                this.ensureFailover(this.getRequest());
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Could not find action method " + method.getName() + " with appropriate signature."));
        }
        return null;
    }

    protected final HttpServletRequest getRequest() {
        if (this._perRequestState == null) {
            throw new IllegalStateException("getRequest was called outside of a valid context.");
        }
        return this._perRequestState.getRequest();
    }

    protected final HttpServletResponse getResponse() {
        if (this._perRequestState == null) {
            throw new IllegalStateException("getResponse was called outside of a valid context.");
        }
        return this._perRequestState.getResponse();
    }

    protected final ActionMapping getMapping() {
        return this.getActionMapping();
    }

    protected final ActionMapping getActionMapping() {
        if (this._perRequestState == null) {
            throw new IllegalStateException("getActionMapping was called outside of a valid context.");
        }
        return this._perRequestState.getActionMapping();
    }

    protected final HttpSession getSession() {
        if (this._perRequestState == null) {
            throw new IllegalStateException("getSession was called outside of a valid context.");
        }
        return this._perRequestState.getRequest().getSession(true);
    }

    PerRequestState setPerRequestState(PerRequestState state) {
        if (state != null) {
            assert (state.getRequest() != null);
            assert (state.getResponse() != null);
        }
        PerRequestState prevState = this._perRequestState;
        this._perRequestState = state;
        return prevState;
    }

    public final ModuleConfig getModuleConfig() {
        assert (this._moduleConfig != null) : "no cached ModuleConfig for " + this.getClass().getName();
        return this._moduleConfig;
    }

    private void initModuleConfig(ServletContext servletContext, HttpServletRequest request) {
        if (this._moduleConfig == null) {
            ActionServlet actionServlet;
            this._moduleConfig = InternalUtils.getModuleConfig(this.getModulePath(), servletContext);
            if (this._moduleConfig == null && (actionServlet = InternalUtils.getActionServlet(servletContext)) instanceof AutoRegisterActionServlet) {
                try {
                    AutoRegisterActionServlet servlet = (AutoRegisterActionServlet)actionServlet;
                    this._moduleConfig = servlet.ensureModuleRegistered(this.getModulePath(), (ServletRequest)request);
                }
                catch (Exception e) {
                    _log.error((Object)("Error while registering module " + this.getModulePath()), (Throwable)e);
                }
            }
            assert (this._moduleConfig != null) : this.getModulePath() + "; " + this.getClass().getName();
        }
    }

    public ModuleConfig getModuleConfig(ServletContext servletContext, HttpServletRequest request) {
        this.initModuleConfig(servletContext, request);
        return this._moduleConfig;
    }

    public static ActionResult lookup(String actionName, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return PageFlowUtils.strutsLookup(context, (ServletRequest)request, response, actionName, null);
    }

    public static ActionResult lookup(String actionName, ServletContext context, HttpServletRequest request, HttpServletResponse response, String actionServletClassName) throws Exception {
        return PageFlowUtils.strutsLookup(context, (ServletRequest)request, response, actionName, null);
    }

    public String resolveAction(String actionName, Object form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward fwd;
        ActionMapping mapping = (ActionMapping)this.getModuleConfig().findActionConfig('/' + actionName);
        if (mapping == null) {
            InternalUtils.throwPageFlowException(new ActionNotFoundException(actionName, this, form), request);
        }
        if ((fwd = this.getActionMethodForward(actionName, form, request, response, mapping)) instanceof Forward) {
            ((Forward)fwd).initialize(mapping, this, request);
        }
        String path = fwd.getPath();
        if (fwd.getContextRelative() || FileUtils.isAbsoluteURI((String)path)) {
            return path;
        }
        return this.getModulePath() + path;
    }

    public String resolveAction(String actionName, Object form) throws Exception {
        return this.resolveAction(actionName, form, this.getRequest(), this.getResponse());
    }

    public String[] getActions() {
        ActionConfig[] actionConfigs = this.getModuleConfig().findActionConfigs();
        ArrayList<String> actionNames = new ArrayList<String>();
        for (int i = 0; i < actionConfigs.length; ++i) {
            ActionConfig ac = actionConfigs[i];
            actionNames.add(ac.getPath().substring(1));
        }
        return actionNames.toArray(new String[0]);
    }

    public boolean isAction(String name) {
        return this.getModuleConfig().findActionConfig('/' + name) != null;
    }

    public boolean isPageFlow() {
        return false;
    }

    protected ActionServlet getServlet() {
        return InternalUtils.getActionServlet(this.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void refresh(HttpServletRequest request, HttpServletResponse response) {
        PerRequestState prevState = this.setPerRequestState(new PerRequestState(request, response, null));
        try {
            this.onRefresh();
        }
        finally {
            this.setPerRequestState(prevState);
        }
    }

    protected void onRefresh() {
    }

    protected void delete() {
        this.deleteFromSession(this.getRequest());
    }

    void savePreviousActionInfo(ActionForm form, HttpServletRequest request, ActionMapping mapping, ServletContext servletContext) {
    }

    void savePreviousPageInfo(ActionForward forward, ActionForm form, ActionMapping mapping, HttpServletRequest request, ServletContext servletContext, boolean isSpecialForward) {
    }

    protected boolean isLongLived() {
        return false;
    }

    protected boolean isNestable() {
        return false;
    }

    protected boolean alwaysTrackPreviousAction() {
        return false;
    }

    protected boolean alwaysTrackPreviousPage() {
        return false;
    }

    boolean incrementRequestCount(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException {
        if (_maxConcurrentRequestCount == -1) {
            _maxConcurrentRequestCount = 4;
            String countStr = servletContext.getInitParameter(MAX_CONCURRENT_REQUESTS_PARAM);
            if (countStr != null) {
                try {
                    _maxConcurrentRequestCount = Integer.parseInt(countStr);
                }
                catch (NumberFormatException e) {
                    _log.error((Object)("Invalid value for servlet context parameterpageflow-max-concurrent-requests: " + countStr), (Throwable)e);
                }
                if (_maxConcurrentRequestCount < 1) {
                    _maxConcurrentRequestCount = 4;
                    _log.error((Object)("Invalid value for servlet context parameterpageflow-max-concurrent-requests: " + countStr));
                }
            }
        }
        if (this._requestCount >= _maxConcurrentRequestCount) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Too many requests to page flow " + this.getClass().getName() + " (" + (this._requestCount + 1) + '>' + _maxConcurrentRequestCount + "); returning error code " + 503));
            }
            response.sendError(503);
            return false;
        }
        ++this._requestCount;
        return true;
    }

    void decrementRequestCount(HttpServletRequest request) {
        assert (this._requestCount > 0) : request.getRequestURI();
        --this._requestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ActionForward invokeExceptionHandler(Method method, Throwable ex, String message, Object formBean, ActionForm wrappedFormBean, ActionMapping actionMapping, HttpServletRequest request, HttpServletResponse response, boolean readonly) throws IOException, ServletException {
        PerRequestState prevState = this.setPerRequestState(new PerRequestState(request, response, actionMapping));
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invoking exception handler method " + method.getName() + '(' + method.getParameterTypes()[0].getName() + ", ...)"));
            }
            try {
                ActionForward retVal = null;
                String actionName = InternalUtils.getActionName(actionMapping);
                if (actionName == null && ex instanceof PageFlowException) {
                    actionName = ((PageFlowException)ex).getActionName();
                }
                try {
                    Object[] args = new Object[]{ex, actionName, message, formBean};
                    retVal = (ActionForward)method.invoke((Object)this, args);
                }
                finally {
                    if (!readonly) {
                        this.ensureFailover(request);
                    }
                }
                ActionForward actionForward = ForwardHandler.forwardTo(retVal, actionMapping, request, response, actionName, this.getModuleConfig(), wrappedFormBean, this.getServletContext(), this);
                return actionForward;
            }
            catch (InvocationTargetException e) {
                try {
                    Throwable target = e.getTargetException();
                    if (target instanceof Exception) {
                        throw (Exception)target;
                    }
                    throw e;
                }
                catch (Throwable e2) {
                    _log.error((Object)("Exception while handling exception " + ex.getClass().getName() + ".  The original exception will be thrown."), e2);
                    ExceptionsHandler eh = ContextCache.get(this.getServletContext()).getExceptionsHandler();
                    if (!eh.eatUnhandledException(eh.unwrapException(e2), request, response, this.getServletContext())) {
                        if (ex instanceof ServletException) {
                            throw (ServletException)ex;
                        }
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw new ServletException(ex);
                    }
                    ActionForward actionForward = null;
                    return actionForward;
                }
            }
        }
        finally {
            this.setPerRequestState(prevState);
        }
    }

    protected void addValidationError(String propertyName, String messageKey, Object[] messageArgs) {
        PageFlowUtils.addValidationError(propertyName, messageKey, messageArgs, (ServletRequest)this.getRequest());
    }

    protected void addValidationError(String propertyName, String messageKey) {
        PageFlowUtils.addValidationError(propertyName, messageKey, (ServletRequest)this.getRequest());
    }

    private static ActionForward handleSimpleAction(PageFlowActionMapping mapping, ActionForm wrappedFormBean, HttpServletRequest request, ServletContext servletContext) {
        Map<String, String> conditionalForwards = mapping.getConditionalForwardsMap();
        if (!conditionalForwards.isEmpty()) {
            Object formBean = InternalUtils.unwrapFormBean(wrappedFormBean);
            for (Map.Entry<String, String> entry : conditionalForwards.entrySet()) {
                String expression = entry.getKey();
                String forwardName = entry.getValue();
                try {
                    if (!InternalExpressionUtils.evaluateCondition(expression, formBean, request, servletContext)) continue;
                    if (_log.isTraceEnabled()) {
                        _log.trace((Object)("Expression '" + expression + "' evaluated to true on simple action " + mapping.getPath() + "; using forward " + forwardName + '.'));
                    }
                    return new Forward(forwardName);
                }
                catch (ELException e) {
                    if (!_log.isErrorEnabled()) continue;
                    _log.error((Object)("Exception occurred evaluating navigation expression '" + expression + "'.  Cause: " + e.getCause()), (Throwable)e);
                }
            }
        }
        String defaultForwardName = mapping.getDefaultForward();
        assert (defaultForwardName != null) : "defaultForwardName is null on Simple Action " + mapping.getPath();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("No expression evaluated to true on simple action " + mapping.getPath() + "; using forward " + defaultForwardName + '.'));
        }
        return new Forward(defaultForwardName);
    }

    protected static Locale getDefaultLocale() {
        return defaultLocale;
    }

    protected String generateToken(HttpServletRequest request) {
        return TOKEN_PROCESSOR.generateToken(request);
    }

    protected DataSource getDataSource(HttpServletRequest request) {
        return this.getDataSource(request, "org.apache.struts.action.DATA_SOURCE");
    }

    protected DataSource getDataSource(HttpServletRequest request, String key) {
        ModuleConfig moduleConfig = this.getModuleConfig();
        return (DataSource)this.getServletContext().getAttribute(key + moduleConfig.getPrefix());
    }

    protected Locale getLocale(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        return locale != null ? locale : DEFAULT_LOCALE;
    }

    protected Locale getLocale() {
        Locale locale = (Locale)this.getSession().getAttribute("org.apache.struts.action.LOCALE");
        return locale != null ? locale : DEFAULT_LOCALE;
    }

    public static Locale retrieveUserLocale(HttpServletRequest request, String locale) {
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        HttpSession session = request.getSession(false);
        Locale userLocale = null;
        if (session != null) {
            userLocale = (Locale)session.getAttribute(locale);
        }
        if (userLocale == null) {
            userLocale = DEFAULT_LOCALE;
        }
        return userLocale;
    }

    protected MessageResources getResources() {
        return (MessageResources)this.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
    }

    protected MessageResources getResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
    }

    protected MessageResources getResources(HttpServletRequest request, String key) {
        return (MessageResources)this.getServletContext().getAttribute(key + this.getModuleConfig().getPrefix());
    }

    protected boolean isCancelled(HttpServletRequest request) {
        return request.getAttribute("org.apache.struts.action.CANCEL") != null;
    }

    protected boolean isTokenValid(HttpServletRequest request) {
        return TOKEN_PROCESSOR.isTokenValid(request, false);
    }

    protected boolean isTokenValid(HttpServletRequest request, boolean reset) {
        return TOKEN_PROCESSOR.isTokenValid(request, reset);
    }

    protected void resetToken(HttpServletRequest request) {
        TOKEN_PROCESSOR.resetToken(request);
    }

    protected void saveErrors(HttpServletRequest request, ActionMessages errors) {
        if (errors == null || errors.isEmpty()) {
            request.removeAttribute("org.apache.struts.action.ERROR");
            return;
        }
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
    }

    protected void saveMessages(HttpServletRequest request, ActionMessages messages) {
        if (messages == null || messages.isEmpty()) {
            request.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
            return;
        }
        request.setAttribute("org.apache.struts.action.ACTION_MESSAGE", (Object)messages);
    }

    protected void saveToken(HttpServletRequest request) {
        TOKEN_PROCESSOR.saveToken(request);
    }

    protected void setLocale(HttpServletRequest request, Locale locale) {
        HttpSession session = request.getSession();
        if (locale == null) {
            locale = FlowController.getDefaultLocale();
        }
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
    }

    protected void setLocale(Locale locale) {
        if (locale == null) {
            locale = FlowController.getDefaultLocale();
        }
        this.getSession().setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
    }

    public ActionForm getFormBean(ActionMapping mapping) {
        if (mapping instanceof PageFlowActionMapping) {
            PageFlowActionMapping pfam = (PageFlowActionMapping)mapping;
            String formMember = pfam.getFormMember();
            try {
                if (formMember != null) {
                    Field field = this.getClass().getDeclaredField(formMember);
                    field.setAccessible(true);
                    return InternalUtils.wrapFormBean(field.get(this));
                }
            }
            catch (Exception e) {
                _log.error((Object)("Could not use page flow member " + formMember + " as the form bean."), (Throwable)e);
            }
        }
        return null;
    }

    PageFlowRequestProcessor getRequestProcessor() {
        ModuleConfig mc = this.getModuleConfig();
        String key = "org.apache.struts.action.REQUEST_PROCESSOR" + mc.getPrefix();
        RequestProcessor rp = (RequestProcessor)this.getServletContext().getAttribute(key);
        if (rp == null && rp == null) {
            try {
                ControllerConfig cc = mc.getControllerConfig();
                rp = (RequestProcessor)RequestUtils.applicationInstance((String)cc.getProcessorClass());
                rp.init(InternalUtils.getActionServlet(this.getServletContext()), mc);
            }
            catch (Exception e) {
                _log.error((Object)("Could not initialize request processor for module " + mc.getPrefix()), (Throwable)e);
            }
        }
        assert (rp == null || rp instanceof PageFlowRequestProcessor) : rp.getClass().getName();
        return (PageFlowRequestProcessor)rp;
    }

    public MutableURI getActionURI(String actionName) throws URISyntaxException {
        if (this._perRequestState == null) {
            throw new IllegalStateException("getActionURI was called outside of a valid context.");
        }
        ServletContext servletContext = this.getServletContext();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        return PageFlowUtils.getActionURI(servletContext, request, response, actionName);
    }

    public String getRewrittenActionURI(String actionName, Map parameters, boolean asValidXml) throws URISyntaxException {
        if (this._perRequestState == null) {
            throw new IllegalStateException("getRewrittenActionURI was called outside of a valid context.");
        }
        ServletContext servletContext = this.getServletContext();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        return PageFlowUtils.getRewrittenActionURI(servletContext, request, response, actionName, parameters, null, asValidXml);
    }

    static class PerRequestState {
        private HttpServletRequest _request;
        private HttpServletResponse _response;
        private ActionMapping _actionMapping;

        public PerRequestState(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) {
            this._request = request;
            this._response = response;
            this._actionMapping = actionMapping;
        }

        public HttpServletRequest getRequest() {
            return this._request;
        }

        public HttpServletResponse getResponse() {
            return this._response;
        }

        public ActionMapping getActionMapping() {
            return this._actionMapping;
        }
    }
}

