/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowManagedObject;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.internal.CachedFacesBackingInfo;
import org.apache.beehive.netui.pageflow.internal.CachedSharedFlowRefInfo;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.util.cache.ClassLevelCache;
import org.apache.beehive.netui.util.logging.Logger;

public abstract class FacesBackingBean
extends PageFlowManagedObject {
    private static final String CACHED_INFO_KEY = "cachedInfo";
    private static final Logger _log = Logger.getInstance(FacesBackingBean.class);
    private Map _pageInputs;

    public void persistInSession(HttpServletRequest request, HttpServletResponse response) {
        HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
        ScopedServletUtils.setScopedSessionAttr((String)"_netui:facesBacking", (Object)this, (HttpServletRequest)unwrappedRequest);
    }

    protected void deleteFromSession(HttpServletRequest request) {
        HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
        ScopedServletUtils.removeScopedSessionAttr((String)"_netui:facesBacking", (HttpServletRequest)unwrappedRequest);
    }

    public void ensureFailover(HttpServletRequest request) {
        HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
        String attr = ScopedServletUtils.getScopedSessionAttrName((String)"_netui:facesBacking", (HttpServletRequest)unwrappedRequest);
        ServletContext servletContext = InternalUtils.getServletContext(request);
        ServerAdapterManager.getServerAdapter(servletContext).ensureFailover(attr, this, unwrappedRequest);
    }

    public String getDisplayName() {
        return this.getClass().getName();
    }

    public void reinitialize(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        CachedSharedFlowRefInfo.SharedFlowFieldInfo[] sharedFlowMemberFields;
        Field pageFlowMemberField;
        Map map;
        if (this._pageInputs == null && (map = InternalUtils.getActionOutputMap((ServletRequest)request, false)) != null) {
            this._pageInputs = Collections.unmodifiableMap(map);
        }
        if (this.fieldIsUninitialized(pageFlowMemberField = this.getCachedInfo().getPageFlowMemberField())) {
            PageFlowController pfc = PageFlowUtils.getCurrentPageFlow(request);
            this.initializeField(pageFlowMemberField, pfc);
        }
        if ((sharedFlowMemberFields = this.getCachedInfo().getSharedFlowMemberFields()) != null) {
            for (int i = 0; i < sharedFlowMemberFields.length; ++i) {
                GlobalApp sf;
                CachedSharedFlowRefInfo.SharedFlowFieldInfo fi = sharedFlowMemberFields[i];
                Field field = fi.field;
                if (!this.fieldIsUninitialized(field)) continue;
                Map<String, SharedFlowController> sharedFlows = PageFlowUtils.getSharedFlows(request);
                String name = fi.sharedFlowName;
                SharedFlowController sharedFlowController = sf = name != null ? sharedFlows.get(name) : PageFlowUtils.getGlobalApp(request);
                if (sf != null) {
                    this.initializeField(field, sf);
                    continue;
                }
                _log.error((Object)("Could not find shared flow with name \"" + fi.sharedFlowName + "\" to initialize field " + field.getName() + " in " + this.getClass().getName()));
            }
        }
        super.reinitialize(request, response, servletContext);
    }

    protected Object getPageInput(String pageInputName) {
        return this._pageInputs != null ? this._pageInputs.get(pageInputName) : null;
    }

    public Map getPageInputMap() {
        return this._pageInputs;
    }

    private CachedFacesBackingInfo getCachedInfo() {
        ClassLevelCache cache = ClassLevelCache.getCache(this.getClass());
        CachedFacesBackingInfo info = (CachedFacesBackingInfo)cache.getCacheObject(CACHED_INFO_KEY);
        if (info == null) {
            info = new CachedFacesBackingInfo(this.getClass());
            cache.setCacheObject(CACHED_INFO_KEY, (Object)info);
        }
        return info;
    }
}

