/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.netui.pageflow.SecurityProtocol;
import org.apache.beehive.netui.pageflow.ServerAdapter;
import org.apache.beehive.netui.pageflow.internal.PageFlowBeanContext;

public abstract class DefaultServerAdapter
implements ServerAdapter {
    private static boolean _productionMode = true;
    private ServletContext _servletContext = null;

    protected DefaultServerAdapter() {
    }

    public boolean isInProductionMode() {
        return _productionMode;
    }

    public SecurityProtocol getSecurityProtocol(String uri, HttpServletRequest request) {
        return SecurityProtocol.UNSPECIFIED;
    }

    public boolean doSecurityRedirect(String uri, HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    public int getListenPort(HttpServletRequest request) {
        return -1;
    }

    public int getSecureListenPort(HttpServletRequest request) {
        return -1;
    }

    public void login(String username, String password, HttpServletRequest request, HttpServletResponse response) throws LoginException {
        throw new UnsupportedOperationException("login is not supported by " + DefaultServerAdapter.class.getName());
    }

    public void logout(boolean invalidateSessions, HttpServletRequest request, HttpServletResponse response) {
        throw new UnsupportedOperationException("logout is not supported by " + DefaultServerAdapter.class.getName());
    }

    public String getFullContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public void ensureFailover(String attrName, Object attrVal, HttpServletRequest request) {
    }

    public void beginRequest(HttpServletRequest request, HttpServletResponse response) {
    }

    public void endRequest(HttpServletRequest request, HttpServletResponse response) {
    }

    public ControlBeanContext createControlBeanContext(HttpServletRequest request, HttpServletResponse response) {
        return new PageFlowBeanContext();
    }

    protected ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public String getPlatformName() {
        return "generic";
    }

    static {
        String productionModeFlag = System.getProperty("beehive.produtionmode");
        if (productionModeFlag != null) {
            _productionMode = Boolean.parseBoolean(productionModeFlag);
        } else if (!$assertionsDisabled) {
            _productionMode = false;
            if (!false) {
                // empty if block
            }
        }
    }
}

