/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model.validation;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.FormValidationDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.FormsetDocument;
import org.apache.beehive.netui.compiler.model.validation.LocaleSet;
import org.apache.beehive.netui.compiler.model.validation.ValidatableEntity;
import org.apache.beehive.netui.compiler.model.validation.ValidatableField;
import org.apache.beehive.netui.compiler.model.validation.ValidatorRule;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidationModel {
    private Map _localeSets = new HashMap();
    private LocaleSet _defaultLocaleSet = new LocaleSet();
    private List _rulesToAddForAllLocales = new ArrayList();
    private boolean _empty = true;

    public void addFieldRuleForAllLocales(RuleInfo ruleInfo, ValidatorRule rule) {
        this._rulesToAddForAllLocales.add(new RuleAdd(ruleInfo, rule));
    }

    public void addFieldRule(RuleInfo ruleInfo, ValidatorRule rule, Locale locale) {
        LocaleSet localeSet = null;
        if (locale == null) {
            localeSet = this._defaultLocaleSet;
        } else {
            localeSet = (LocaleSet)this._localeSets.get(locale);
            if (localeSet == null) {
                localeSet = new LocaleSet(locale);
                this._localeSets.put(locale, localeSet);
            }
            if (this.getField(ruleInfo, this._defaultLocaleSet) == null) {
                this.addFieldRule(ruleInfo, (ValidatorRule)null, this._defaultLocaleSet);
            }
        }
        this.addFieldRule(ruleInfo, rule, localeSet);
    }

    private ValidatableField getField(RuleInfo ruleInfo, LocaleSet localeSet) {
        String entityName = ruleInfo.getEntityName();
        ValidatableEntity entity = localeSet.getEntity(entityName);
        if (entity == null) {
            return null;
        }
        String fieldName = ruleInfo.getFieldName();
        return entity.getField(fieldName);
    }

    private boolean hasFieldRule(RuleInfo ruleInfo, ValidatorRule rule, LocaleSet localeSet) {
        ValidatableField field = this.getField(ruleInfo, localeSet);
        if (field == null) {
            return false;
        }
        return field.hasRule(rule);
    }

    private void addFieldRule(RuleInfo ruleInfo, ValidatorRule rule, LocaleSet localeSet) {
        String fieldName;
        ValidatableField field;
        String entityName = ruleInfo.getEntityName();
        ValidatableEntity entity = localeSet.getEntity(entityName);
        if (entity == null) {
            entity = new ValidatableEntity(entityName);
            localeSet.addValidatableEntity(entity);
        }
        if ((field = entity.getField(fieldName = ruleInfo.getFieldName())) == null) {
            field = new ValidatableField(fieldName, ruleInfo.getFieldDisplayName(), ruleInfo.getFieldDisplayNameKey());
            entity.addField(field);
        }
        if (rule != null) {
            field.addRule(rule);
        }
    }

    public void writeXml(PrintStream outputStream, File mergeFile) throws XmlException, IOException {
        FormValidationDocument.FormValidation formValidationElement;
        FormValidationDocument doc;
        XmlDocumentProperties dp;
        if (this._rulesToAddForAllLocales != null) {
            for (int i = 0; i < this._rulesToAddForAllLocales.size(); ++i) {
                RuleAdd ruleAdd = (RuleAdd)this._rulesToAddForAllLocales.get(i);
                for (LocaleSet localeSet : this._localeSets.values()) {
                    if (this.hasFieldRule(ruleAdd.ruleInfo, ruleAdd.rule, localeSet)) continue;
                    this.addFieldRule(ruleAdd.ruleInfo, ruleAdd.rule, localeSet);
                }
                if (this.hasFieldRule(ruleAdd.ruleInfo, ruleAdd.rule, this._defaultLocaleSet)) continue;
                this.addFieldRule(ruleAdd.ruleInfo, ruleAdd.rule, this._defaultLocaleSet);
            }
            this._rulesToAddForAllLocales = null;
        }
        if ((dp = (doc = mergeFile != null && mergeFile.canRead() ? FormValidationDocument.Factory.parse(mergeFile) : FormValidationDocument.Factory.newInstance()).documentProperties()).getDoctypeName() == null) {
            dp.setDoctypeName("form-validation");
        }
        if (dp.getDoctypePublicId() == null) {
            dp.setDoctypePublicId("-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0//EN");
        }
        if (dp.getDoctypeSystemId() == null) {
            dp.setDoctypeSystemId("http://jakarta.apache.org/commons/dtds/validator_1_0.dtd");
        }
        if ((formValidationElement = doc.getFormValidation()) == null) {
            formValidationElement = doc.addNewFormValidation();
        }
        XmlCursor curs = formValidationElement.newCursor();
        String headerComment = this.getHeaderComment(mergeFile);
        if (headerComment != null) {
            curs.insertComment(headerComment);
        }
        this.writeLocaleSets(formValidationElement);
        this.writeLocaleSet(this._defaultLocaleSet, formValidationElement);
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        doc.save(outputStream, options);
    }

    protected String getHeaderComment(File mergeFile) {
        return null;
    }

    private void writeLocaleSets(FormValidationDocument.FormValidation formValidationElement) {
        ArrayList allLocales = new ArrayList(this._localeSets.keySet());
        ArrayList<Locale> langCountryVariant = new ArrayList<Locale>();
        ArrayList<Locale> langCountry = new ArrayList<Locale>();
        ArrayList<Locale> lang = new ArrayList<Locale>();
        for (Locale locale : allLocales) {
            if (locale.getCountry().length() > 0) {
                if (locale.getVariant().length() > 0) {
                    langCountryVariant.add(locale);
                    continue;
                }
                langCountry.add(locale);
                continue;
            }
            lang.add(locale);
        }
        this.writeLocaleSets(langCountryVariant, formValidationElement);
        this.writeLocaleSets(langCountry, formValidationElement);
        this.writeLocaleSets(lang, formValidationElement);
    }

    private void writeLocaleSets(Collection<Locale> locales, FormValidationDocument.FormValidation formValidationElement) {
        for (Locale locale : locales) {
            LocaleSet localeSet = (LocaleSet)this._localeSets.get(locale);
            this.writeLocaleSet(localeSet, formValidationElement);
        }
    }

    private void writeLocaleSet(LocaleSet localeSet, FormValidationDocument.FormValidation formValidationElement) {
        FormsetDocument.Formset[] existingFormSetElements = formValidationElement.getFormsetArray();
        FormsetDocument.Formset formSetElementToUse = null;
        Locale locale = localeSet.getLocale();
        for (int i = 0; i < existingFormSetElements.length; ++i) {
            FormsetDocument.Formset existingFormSetElement = existingFormSetElements[i];
            if (locale == null && existingFormSetElement.getLanguage() == null) {
                formSetElementToUse = existingFormSetElement;
                break;
            }
            if (locale == null || !locale.getLanguage().equals(existingFormSetElement.getLanguage()) || (locale.getCountry().length() != 0 || existingFormSetElement.getCountry() != null) && !locale.getCountry().equals(existingFormSetElement.getCountry()) || (locale.getVariant().length() != 0 || existingFormSetElement.getVariant() != null) && !locale.getVariant().equals(existingFormSetElement.getVariant())) continue;
            formSetElementToUse = existingFormSetElement;
            break;
        }
        if (formSetElementToUse == null) {
            formSetElementToUse = formValidationElement.addNewFormset();
        }
        localeSet.writeToXMLBean(formSetElementToUse);
    }

    public boolean isEmpty() {
        return this._empty;
    }

    protected void setEmpty(boolean empty) {
        this._empty = empty;
    }

    public abstract String getOutputFileURI();

    private static class RuleAdd {
        public RuleInfo ruleInfo;
        public ValidatorRule rule;

        public RuleAdd(RuleInfo ruleInfo, ValidatorRule rule) {
            this.ruleInfo = ruleInfo;
            this.rule = rule;
        }
    }

    public static class RuleInfo {
        private String _entityName;
        private String _fieldName;
        private String _fieldDisplayName;
        private String _fieldDisplayNameKey;

        public RuleInfo(String entityName, String fieldName, String fieldDisplayName, String fieldDisplayNameKey) {
            this._entityName = entityName;
            this._fieldName = fieldName;
            this._fieldDisplayName = fieldDisplayName;
            this._fieldDisplayNameKey = fieldDisplayNameKey;
        }

        public String getEntityName() {
            return this._entityName;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getFieldDisplayName() {
            return this._fieldDisplayName;
        }

        public String getFieldDisplayNameKey() {
            return this._fieldDisplayNameKey;
        }
    }
}

