/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.Arg0Document;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.FieldDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.MsgDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.VarDocument;
import org.apache.beehive.netui.compiler.model.validation.ValidatorRule;

public class ValidatableField {
    private String _propertyName;
    private String _displayName;
    private String _displayNameKey;
    private List _rules = new ArrayList();

    public ValidatableField(String propertyName, String displayName, String displayNameKey) {
        this._propertyName = propertyName;
        this._displayName = displayName;
        this._displayNameKey = displayNameKey;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    protected boolean hasRule(ValidatorRule rule) {
        assert (rule != null);
        String name = rule.getRuleName();
        for (int i = 0; i < this._rules.size(); ++i) {
            if (!((ValidatorRule)this._rules.get(i)).getRuleName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addRule(ValidatorRule rule) {
        assert (rule != null);
        this._rules.add(rule);
    }

    public ValidatorRule[] getRules() {
        return this._rules.toArray(new ValidatorRule[this._rules.size()]);
    }

    String getDependsList() {
        StringBuffer listStr = new StringBuffer();
        for (int i = 0; i < this._rules.size(); ++i) {
            if (i > 0) {
                listStr.append(',');
            }
            listStr.append(((ValidatorRule)this._rules.get(i)).getRuleName());
        }
        return listStr.toString();
    }

    public void writeToXMLBean(FieldDocument.Field fieldElement) {
        String depends;
        assert (fieldElement.getProperty().equals(this._propertyName));
        if (fieldElement.getDepends() == null && (depends = this.getDependsList()) != null && depends.length() > 0) {
            fieldElement.setDepends(depends);
        }
        String displayName = null;
        boolean displayNameIsResource = false;
        if (this._displayName != null) {
            displayName = "NETUI-EXPRESSION:" + this._displayName;
            displayNameIsResource = false;
        } else if (this._displayNameKey != null) {
            displayName = this._displayNameKey;
            displayNameIsResource = true;
        } else {
            displayName = Character.toUpperCase(this._propertyName.charAt(0)) + this._propertyName.substring(1);
        }
        Arg0Document.Arg0[] arg0Array = fieldElement.getArg0Array();
        Arg0Document.Arg0 defaultArg0Element = null;
        for (int i = 0; i < arg0Array.length; ++i) {
            Arg0Document.Arg0 arg0 = arg0Array[i];
            if (arg0.getName() != null) continue;
            defaultArg0Element = arg0;
            break;
        }
        if (defaultArg0Element == null && this._rules.size() > 0) {
            defaultArg0Element = fieldElement.addNewArg0();
        }
        if (defaultArg0Element != null) {
            defaultArg0Element.setKey(displayName);
            defaultArg0Element.setResource(Boolean.toString(displayNameIsResource));
        }
        VarDocument.Var[] existingVars = fieldElement.getVarArray();
        for (int i = 0; i < this._rules.size(); ++i) {
            Map<String, String> ruleVars;
            ValidatorRule rule = (ValidatorRule)this._rules.get(i);
            String messageKey = rule.getMessageKey();
            String message = rule.getMessage();
            if (messageKey != null || message != null) {
                MsgDocument.Msg[] existingMsgElements = fieldElement.getMsgArray();
                MsgDocument.Msg msgElementToUse = null;
                for (int j = 0; j < existingMsgElements.length; ++j) {
                    MsgDocument.Msg existingMsgElement = existingMsgElements[j];
                    if (!rule.getRuleName().equals(existingMsgElement.getName())) continue;
                    msgElementToUse = existingMsgElement;
                    break;
                }
                if (msgElementToUse == null) {
                    msgElementToUse = fieldElement.addNewMsg();
                    msgElementToUse.setName(rule.getRuleName());
                }
                if (messageKey != null) {
                    msgElementToUse.setKey(messageKey);
                    msgElementToUse.setResource(Boolean.TRUE.toString());
                } else {
                    msgElementToUse.setKey("NETUI-EXPRESSION:" + message);
                    msgElementToUse.setResource(Boolean.FALSE.toString());
                }
            }
            if ((ruleVars = rule.getVars()) != null) {
                for (Map.Entry<String, String> entry : ruleVars.entrySet()) {
                    String varName = entry.getKey();
                    VarDocument.Var varElementToUse = null;
                    for (int k = 0; k < existingVars.length; ++k) {
                        VarDocument.Var existingVar = existingVars[k];
                        if (!varName.equals(existingVar.getVarName())) continue;
                        varElementToUse = existingVar;
                        break;
                    }
                    if (varElementToUse == null) {
                        varElementToUse = fieldElement.addNewVar();
                        varElementToUse.setVarName(varName);
                    }
                    if (varElementToUse.getVarValue() != null) continue;
                    varElementToUse.setVarValue(entry.getValue());
                }
            }
            Iterator<Map.Entry<String, String>> j = ruleVars != null ? ruleVars.keySet().iterator() : null;
            this.setRuleArg(rule, 0, fieldElement, null);
            this.setRuleArg(rule, 1, fieldElement, j != null && j.hasNext() ? (String)((Object)j.next()) : null);
            this.setRuleArg(rule, 2, fieldElement, j != null && j.hasNext() ? (String)((Object)j.next()) : null);
            this.setRuleArg(rule, 3, fieldElement, j != null && j.hasNext() ? (String)((Object)j.next()) : null);
        }
    }

    void setRuleArg(ValidatorRule rule, int argNum, FieldDocument.Field fieldElement, String altMessageVar) {
        block11: {
            try {
                Class<?> ruleClass = rule.getClass();
                Class<?> fieldElementClass = fieldElement.getClass();
                ValidatorRule.MessageArg arg = (ValidatorRule.MessageArg)ruleClass.getMethod("getArg" + argNum, new Class[0]).invoke((Object)rule, new Object[0]);
                String ruleName = rule.getRuleName();
                Object argElementToUse = null;
                Object[] existingArgElements = (Object[])fieldElementClass.getMethod("getArg" + argNum + "Array", new Class[0]).invoke((Object)fieldElement, new Object[0]);
                for (int i = 0; i < existingArgElements.length; ++i) {
                    Object existingElement = existingArgElements[i];
                    if (!ruleName.equals(existingElement.getClass().getMethod("getName", new Class[0]).invoke(existingElement, new Object[0]))) continue;
                    argElementToUse = existingElement;
                    break;
                }
                if (arg != null || altMessageVar != null) {
                    if (argElementToUse == null) {
                        argElementToUse = fieldElementClass.getMethod("addNewArg" + argNum, new Class[0]).invoke((Object)fieldElement, new Object[0]);
                    }
                    Class<?> argElementToUseClass = argElementToUse.getClass();
                    if (arg != null) {
                        String argMessage = arg.getMessage();
                        String key = arg.isKey() ? argMessage : "NETUI-EXPRESSION:" + argMessage;
                        argElementToUseClass.getMethod("setKey", String.class).invoke(argElementToUse, key);
                        String isResource = Boolean.toString(arg.isKey());
                        argElementToUseClass.getMethod("setResource", String.class).invoke(argElementToUse, isResource);
                        argElementToUseClass.getMethod("setName", String.class).invoke(argElementToUse, ruleName);
                    } else {
                        altMessageVar = "${var:" + altMessageVar + '}';
                        argElementToUseClass.getMethod("setKey", String.class).invoke(argElementToUse, altMessageVar);
                        argElementToUseClass.getMethod("setResource", String.class).invoke(argElementToUse, "false");
                        argElementToUseClass.getMethod("setName", String.class).invoke(argElementToUse, ruleName);
                    }
                }
            }
            catch (NoSuchMethodException e) {
                assert (false) : e;
            }
            catch (IllegalAccessException e) {
                assert (false) : e;
            }
            catch (InvocationTargetException e) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)e);
            }
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayNameKey() {
        return this._displayNameKey;
    }

    public void setDisplayNameKey(String displayNameKey) {
        this._displayNameKey = displayNameKey;
    }
}

