/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model.validation;

import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.FieldDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.FormDocument;
import org.apache.beehive.netui.compiler.model.validation.ValidatableField;

class ValidatableEntity {
    private String _entityName;
    private Map _fields = new HashMap();

    public ValidatableEntity(String entityName) {
        this._entityName = entityName;
    }

    protected String getEntityName() {
        return this._entityName;
    }

    public void addField(ValidatableField field) {
        this._fields.put(field.getPropertyName(), field);
    }

    public ValidatableField getField(String fieldName) {
        return (ValidatableField)this._fields.get(fieldName);
    }

    public void writeToXMLBean(FormDocument.Form formElement) {
        assert (formElement.getName().equals(this._entityName));
        FieldDocument.Field[] existingFieldElements = formElement.getFieldArray();
        for (ValidatableField field : this._fields.values()) {
            FieldDocument.Field fieldElementToUse = null;
            String fieldPropertyName = field.getPropertyName();
            for (int j = 0; j < existingFieldElements.length; ++j) {
                FieldDocument.Field existingFieldElement = existingFieldElements[j];
                if (!fieldPropertyName.equals(existingFieldElement.getProperty())) continue;
                fieldElementToUse = existingFieldElement;
                break;
            }
            if (fieldElementToUse == null) {
                fieldElementToUse = formElement.addNewField();
                fieldElementToUse.setProperty(fieldPropertyName);
            }
            field.writeToXMLBean(fieldElementToUse);
        }
    }
}

