/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model.validation;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.FormDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.validator.FormsetDocument;
import org.apache.beehive.netui.compiler.model.validation.ValidatableEntity;

public class LocaleSet {
    private Locale _locale;
    private Map _entities = new HashMap();

    public LocaleSet() {
        this._locale = null;
    }

    public LocaleSet(Locale locale) {
        this._locale = locale;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public ValidatableEntity getEntity(String entityName) {
        return (ValidatableEntity)this._entities.get(entityName);
    }

    public void addValidatableEntity(ValidatableEntity entity) {
        this._entities.put(entity.getEntityName(), entity);
    }

    public void writeToXMLBean(FormsetDocument.Formset formset) {
        if (this._locale != null) {
            formset.setLanguage(this._locale.getLanguage());
            if (this._locale.getCountry().length() > 0) {
                formset.setCountry(this._locale.getCountry());
                if (this._locale.getVariant().length() > 0) {
                    formset.setVariant(this._locale.getVariant());
                }
            }
        }
        FormDocument.Form[] existingFormElements = formset.getFormArray();
        for (ValidatableEntity entity : this._entities.values()) {
            String entityName = entity.getEntityName();
            FormDocument.Form formElementToUse = null;
            for (int j = 0; j < existingFormElements.length; ++j) {
                FormDocument.Form formElement = existingFormElements[j];
                if (!entityName.equals(formElement.getName())) continue;
                formElementToUse = formElement;
                break;
            }
            if (formElementToUse == null) {
                formElementToUse = formset.addNewForm();
                formElementToUse.setName(entityName);
            }
            entity.writeToXMLBean(formElementToUse);
        }
    }
}

