/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beehive.netui.compiler.model.AbstractForwardContainer;
import org.apache.beehive.netui.compiler.model.ActionModel;
import org.apache.beehive.netui.compiler.model.ExceptionContainer;
import org.apache.beehive.netui.compiler.model.ExceptionModel;
import org.apache.beehive.netui.compiler.model.FormBeanModel;
import org.apache.beehive.netui.compiler.model.ForwardContainer;
import org.apache.beehive.netui.compiler.model.MessageResourcesModel;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.beehive.netui.compiler.model.schema.struts11.ActionDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.ActionMappingsDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.ControllerDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.ExceptionDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.FormBeanDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.FormBeansDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.ForwardDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.GlobalExceptionsDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.GlobalForwardsDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.MessageResourcesDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.PlugInDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.SetPropertyDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.StrutsConfigDocument;
import org.apache.beehive.netui.compiler.model.validation.ValidationModel;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsApp
extends AbstractForwardContainer
implements ForwardContainer,
ExceptionContainer {
    private HashMap<String, ActionModel> _actionMappings = new HashMap();
    private ArrayList<ExceptionModel> _exceptionCatches = new ArrayList();
    private ArrayList<MessageResourcesModel> _messageResources = new ArrayList();
    private HashMap<String, FormBeanModel> _formBeans = new HashMap();
    private ValidationModel _validationModel;
    private boolean _returnToPageDisabled = true;
    private boolean _returnToActionDisabled = true;
    private boolean _isNestedPageFlow = false;
    private boolean _isLongLivedPageFlow = false;
    private boolean _isSharedFlow = false;
    private Map<String, String> _sharedFlows = null;
    private String _controllerClassName = null;
    private String _multipartHandlerClassName = null;
    private List<String> _tilesDefinitionsConfigs = null;
    protected static final String DUPLICATE_ACTION_COMMENT = "Note that there is more than one action with path \"{0}\".  Use a form-qualified action path if this is not the one you want.";
    protected static final String PAGEFLOW_REQUESTPROCESSOR_CLASSNAME = "org.apache.beehive.netui.pageflow.PageFlowRequestProcessor";
    protected static final String PAGEFLOW_CONTROLLER_CONFIG_CLASSNAME = "org.apache.beehive.netui.pageflow.config.PageFlowControllerConfig";
    protected static final String STRUTS_CONFIG_PREFIX = "jpf-struts-config";
    protected static final String STRUTS_CONFIG_EXTENSION = ".xml";
    protected static final char STRUTS_CONFIG_SEPARATOR = '-';
    protected static final String WEBINF_DIR_NAME = "WEB-INF";
    protected static final String STRUTSCONFIG_OUTPUT_DIR = "/WEB-INF/.pageflow-struts-generated";
    protected static final String VALIDATOR_PLUG_IN_CLASSNAME = "org.apache.struts.validator.ValidatorPlugIn";
    protected static final String VALIDATOR_PATHNAMES_PROPERTY = "pathnames";
    protected static final String TILES_PLUG_IN_CLASSNAME = "org.apache.struts.tiles.TilesPlugin";
    protected static final String TILES_DEFINITIONS_CONFIG_PROPERTY = "definitions-config";
    protected static final String TILES_MODULE_AWARE_PROPERTY = "moduleAware";
    protected static final String NETUI_VALIDATOR_RULES_URI = "/WEB-INF/netui-validator-rules.xml";
    protected static final String STRUTS_VALIDATOR_RULES_URI = "/WEB-INF/validator-rules.xml";

    public StrutsApp(String controllerClassName) {
        super(null);
        this.setParentApp(this);
        this._controllerClassName = controllerClassName;
        MessageResourcesModel mrm = new MessageResourcesModel(this);
        mrm.setParameter("org.apache.beehive.netui.pageflow.validation.defaultMessages");
        mrm.setKey("_defaultValidationMessages");
        mrm.setReturnNull(true);
        this.addMessageResources(mrm);
    }

    public void addMessageResources(MessageResourcesModel mr) {
        this._messageResources.add(mr);
    }

    private void addDisambiguatedActionMapping(ActionModel mapping) {
        if (mapping.getFormBeanName() != null) {
            String qualifiedPath = this.getFormQualifiedActionPath(mapping);
            ActionModel qualifiedMapping = new ActionModel(mapping, qualifiedPath);
            qualifiedMapping.setUnqualifiedActionPath(mapping.getPath());
            this._actionMappings.put(qualifiedPath, qualifiedMapping);
        }
    }

    public void addActionMapping(ActionModel mapping) {
        String mappingPath = mapping.getPath();
        ActionModel conflictingActionMapping = this._actionMappings.get(mappingPath);
        if (conflictingActionMapping != null) {
            ActionModel defaultMappingForThisPath = conflictingActionMapping;
            if (mapping.getFormBeanName() == null || conflictingActionMapping.getFormBeanName() != null && this.getBeanType(mapping).compareTo(this.getBeanType(conflictingActionMapping)) < 0) {
                this._actionMappings.put(mappingPath, mapping);
                defaultMappingForThisPath = mapping;
                conflictingActionMapping.setOverloaded(false);
            }
            this.addDisambiguatedActionMapping(mapping);
            this.addDisambiguatedActionMapping(conflictingActionMapping);
            defaultMappingForThisPath.setOverloaded(true);
            defaultMappingForThisPath.setComment(DUPLICATE_ACTION_COMMENT.replaceAll("\\{0\\}", mappingPath));
        } else {
            this._actionMappings.put(mappingPath, mapping);
        }
    }

    public String getBeanType(ActionModel actionMapping) {
        String beanType = actionMapping.getFormClass();
        if (beanType == null) {
            FormBeanModel bean = this.getFormBean(actionMapping.getFormBeanName());
            assert (bean != null);
            beanType = bean.getType();
        }
        return beanType;
    }

    protected String getFormQualifiedActionPath(ActionModel action) {
        assert (action.getFormBeanName() != null) : "action " + action.getPath() + " has no form bean";
        String beanType = this.getBeanType(action);
        return action.getPath() + '_' + StrutsApp.makeFullyQualifiedBeanName(beanType);
    }

    @Override
    public void addException(ExceptionModel c) {
        this._exceptionCatches.add(c);
    }

    public FormBeanModel[] getFormBeans() {
        return this.getFormBeansAsList().toArray(new FormBeanModel[0]);
    }

    public List<FormBeanModel> getFormBeansAsList() {
        ArrayList<FormBeanModel> retList = new ArrayList<FormBeanModel>();
        for (FormBeanModel fb : this._formBeans.values()) {
            if (fb == null) continue;
            retList.add(fb);
        }
        return retList;
    }

    public FormBeanModel getFormBean(String formBeanName) {
        return this._formBeans.get(formBeanName);
    }

    public FormBeanModel getFormBeanByActualType(String actualTypeName) {
        for (FormBeanModel formBean : this._formBeans.values()) {
            if (formBean == null || !formBean.getActualType().equals(actualTypeName)) continue;
            return formBean;
        }
        return null;
    }

    public void addFormBean(FormBeanModel newFormBean) {
        this._formBeans.put(newFormBean.getName(), newFormBean);
    }

    public void deleteFormBean(FormBeanModel formBean) {
        this._formBeans.remove(formBean.getName());
    }

    public static File getWebappRootFromJpf(File jpf) throws NoWebInfDirectoryException {
        File webappRoot = null;
        for (File dir = jpf.getAbsoluteFile().getParentFile(); dir != null; dir = dir.getParentFile()) {
            if (!new File(dir, WEBINF_DIR_NAME).isDirectory()) continue;
            webappRoot = dir;
            break;
        }
        if (webappRoot == null) {
            throw new NoWebInfDirectoryException(jpf.getPath());
        }
        return webappRoot;
    }

    public String getFormNameForType(String formType) {
        int lastQualifier = formType.lastIndexOf(36);
        if (lastQualifier == -1) {
            lastQualifier = formType.lastIndexOf(46);
        }
        String formBeanName = formType.substring(lastQualifier + 1);
        if (this._formBeans.containsKey(formBeanName = Character.toLowerCase(formBeanName.charAt(0)) + formBeanName.substring(1))) {
            String conflictingName = formBeanName;
            formBeanName = StrutsApp.makeFullyQualifiedBeanName(formType);
            FormBeanModel conflictingBean = this._formBeans.get(conflictingName);
            if (conflictingBean != null) {
                String nonConflictingName = StrutsApp.makeFullyQualifiedBeanName(conflictingBean.getType());
                conflictingBean.setName(nonConflictingName);
                this._formBeans.put(nonConflictingName, conflictingBean);
                for (ActionModel mapping : this._actionMappings.values()) {
                    if (mapping.getFormBeanName() == null || !mapping.getFormBeanName().equals(conflictingName)) continue;
                    mapping.setFormBeanName(nonConflictingName);
                }
            }
            this._formBeans.put(conflictingName, null);
        }
        return formBeanName;
    }

    protected static String makeFullyQualifiedBeanName(String formType) {
        return formType.replace('.', '_').replace('$', '_');
    }

    @Override
    protected ForwardDocument.Forward addNewForward(XmlObject xmlObject) {
        return ((GlobalForwardsDocument.GlobalForwards)xmlObject).addNewForward();
    }

    protected Map getFormBeansMap() {
        return this._formBeans;
    }

    protected List getExceptionCatchesList() {
        return this._exceptionCatches;
    }

    protected List<ActionModel> getSortedActionMappings() {
        ArrayList<ActionModel> sortedActionMappings = new ArrayList<ActionModel>();
        sortedActionMappings.addAll(this._actionMappings.values());
        Collections.sort(sortedActionMappings, new ActionMappingComparator());
        return sortedActionMappings;
    }

    protected List<MessageResourcesModel> getMessageResourcesList() {
        return this._messageResources;
    }

    public MessageResourcesModel getDefaultMessageResources() {
        for (MessageResourcesModel i : this._messageResources) {
            if (i.getKey() != null) continue;
            return i;
        }
        return null;
    }

    public boolean isReturnToPageDisabled() {
        return this._returnToPageDisabled;
    }

    public boolean isReturnToActionDisabled() {
        return this._returnToActionDisabled;
    }

    public void setReturnToPageDisabled(boolean disabled) {
        this._returnToPageDisabled = disabled;
    }

    public void setReturnToActionDisabled(boolean disabled) {
        this._returnToActionDisabled = disabled;
    }

    public void setValidationModel(ValidationModel validationModel) {
        if (!validationModel.isEmpty()) {
            this._validationModel = validationModel;
        }
    }

    public void writeXml(PrintStream outputStream, File mergeFile, File webappRoot) throws IOException, XmlException, NoWebInfDirectoryException {
        StrutsConfigDocument.StrutsConfig scElement;
        StrutsConfigDocument doc = mergeFile != null && mergeFile.canRead() ? StrutsConfigDocument.Factory.parse(mergeFile) : StrutsConfigDocument.Factory.newInstance();
        XmlDocumentProperties docProps = doc.documentProperties();
        if (docProps.getDoctypeName() == null) {
            docProps.setDoctypeName("struts-config");
        }
        if (docProps.getDoctypePublicId() == null) {
            docProps.setDoctypePublicId("-//Apache Software Foundation//DTD Struts Configuration 1.1//EN");
        }
        if (docProps.getDoctypeSystemId() == null) {
            docProps.setDoctypeSystemId("http://jakarta.apache.org/struts/dtds/struts-config_1_1.dtd");
        }
        if ((scElement = doc.getStrutsConfig()) == null) {
            scElement = doc.addNewStrutsConfig();
        }
        XmlCursor curs = scElement.newCursor();
        String headerComment = this.getHeaderComment(mergeFile);
        if (headerComment != null) {
            curs.insertComment(headerComment);
        }
        this.writeFormBeans(scElement);
        this.writeExceptions(scElement);
        GlobalForwardsDocument.GlobalForwards globalForwards = scElement.getGlobalForwards();
        if (globalForwards == null) {
            globalForwards = scElement.addNewGlobalForwards();
        }
        this.writeForwards(globalForwards.getForwardArray(), globalForwards);
        this.writeActionMappings(scElement);
        this.writeMessageResources(scElement);
        this.writeControllerElement(scElement);
        this.writeValidatorInit(scElement);
        this.writeTilesInit(scElement);
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        doc.save(outputStream, options);
    }

    private void writeMessageResources(StrutsConfigDocument.StrutsConfig scElement) {
        MessageResourcesDocument.MessageResources[] existingMessageResources = scElement.getMessageResourcesArray();
        for (MessageResourcesModel mr : this.getMessageResourcesList()) {
            if (mr == null) continue;
            MessageResourcesDocument.MessageResources mrToEdit = null;
            for (int j = 0; j < existingMessageResources.length; ++j) {
                String existingKey = existingMessageResources[j].getKey();
                if ((existingKey != null || mr.getKey() != null) && (existingKey == null || mr.getKey() == null || !existingKey.equals(mr.getKey()))) continue;
                mrToEdit = existingMessageResources[j];
                break;
            }
            if (mrToEdit == null) {
                mrToEdit = scElement.addNewMessageResources();
            }
            mr.writeToXMLBean(mrToEdit);
        }
    }

    private void writeActionMappings(StrutsConfigDocument.StrutsConfig scElement) {
        ActionMappingsDocument.ActionMappings actionMappings = scElement.getActionMappings();
        if (actionMappings == null) {
            actionMappings = scElement.addNewActionMappings();
        }
        ActionDocument.Action[] existingActions = actionMappings.getActionArray();
        List<ActionModel> actionMappingsList = this.getSortedActionMappings();
        for (int i = 0; i < actionMappingsList.size(); ++i) {
            ActionModel am = actionMappingsList.get(i);
            ActionDocument.Action actionMappingToEdit = null;
            for (int j = 0; j < existingActions.length; ++j) {
                if (!am.getPath().equals(existingActions[j].getPath())) continue;
                actionMappingToEdit = existingActions[j];
                break;
            }
            if (actionMappingToEdit == null) {
                actionMappingToEdit = actionMappings.addNewAction();
            }
            am.writeToXMLBean(actionMappingToEdit);
        }
    }

    private void writeExceptions(StrutsConfigDocument.StrutsConfig scElement) {
        List exceptionCatches;
        GlobalExceptionsDocument.GlobalExceptions globalExceptions = scElement.getGlobalExceptions();
        if (globalExceptions == null) {
            globalExceptions = scElement.addNewGlobalExceptions();
        }
        if ((exceptionCatches = this.getExceptionCatchesList()) != null && !exceptionCatches.isEmpty()) {
            ExceptionDocument.Exception[] existingExceptions = globalExceptions.getExceptionArray();
            for (int i = 0; i < exceptionCatches.size(); ++i) {
                ExceptionModel ec = (ExceptionModel)exceptionCatches.get(i);
                ExceptionDocument.Exception exceptionToEdit = null;
                for (int j = 0; j < existingExceptions.length; ++j) {
                    if (!ec.getType().equals(existingExceptions[j].getType())) continue;
                    exceptionToEdit = existingExceptions[j];
                    break;
                }
                if (exceptionToEdit == null) {
                    exceptionToEdit = globalExceptions.addNewException();
                }
                ec.writeToXMLBean(exceptionToEdit);
            }
        }
    }

    private void writeFormBeans(StrutsConfigDocument.StrutsConfig scElement) {
        FormBeansDocument.FormBeans formBeans = scElement.getFormBeans();
        if (formBeans == null) {
            formBeans = scElement.addNewFormBeans();
        }
        FormBeanDocument.FormBean[] existingBeans = formBeans.getFormBeanArray();
        for (FormBeanModel fb : this.getFormBeansMap().values()) {
            if (fb == null) continue;
            FormBeanDocument.FormBean formBeanToEdit = null;
            for (int j = 0; j < existingBeans.length; ++j) {
                if (!existingBeans[j].getName().equals(fb.getName())) continue;
                formBeanToEdit = existingBeans[j];
                break;
            }
            if (formBeanToEdit == null) {
                formBeanToEdit = formBeans.addNewFormBean();
            }
            fb.writeToXMLBean(formBeanToEdit);
        }
    }

    protected void writeControllerElement(StrutsConfigDocument.StrutsConfig scElement) {
        if (scElement.getController() == null) {
            ControllerDocument.Controller controller = scElement.addNewController();
            controller.setProcessorClass(PAGEFLOW_REQUESTPROCESSOR_CLASSNAME);
            controller.setInputForward(ControllerDocument.Controller.InputForward.TRUE);
            if (this._multipartHandlerClassName != null) {
                controller.setMultipartClass(this._multipartHandlerClassName);
            }
            if (this._isNestedPageFlow) {
                StrutsApp.addSetProperty(controller, "isNestedPageFlow", "true");
            }
            if (this._isLongLivedPageFlow) {
                StrutsApp.addSetProperty(controller, "isLongLivedPageFlow", "true");
            }
            if (this._isSharedFlow) {
                StrutsApp.addSetProperty(controller, "isSharedFlow", "true");
            }
            if (this.isReturnToPageDisabled()) {
                StrutsApp.addSetProperty(controller, "isReturnToPageDisabled", "true");
            }
            if (this.isReturnToActionDisabled()) {
                StrutsApp.addSetProperty(controller, "isReturnToActionDisabled", "true");
            }
            if (this._sharedFlows != null) {
                StringBuilder str = new StringBuilder();
                boolean first = true;
                for (Map.Entry<String, String> entry : this._sharedFlows.entrySet()) {
                    if (!first) {
                        str.append(',');
                    }
                    first = false;
                    String name = entry.getKey();
                    String type = entry.getValue();
                    str.append(name).append('=').append(type);
                }
                StrutsApp.addSetProperty(controller, "sharedFlows", str.toString());
            }
            StrutsApp.addSetProperty(controller, "controllerClass", this._controllerClassName);
            MessageResourcesDocument.MessageResources[] mrArray = scElement.getMessageResourcesArray();
            for (int i = 0; i < mrArray.length; ++i) {
                MessageResourcesDocument.MessageResources messageResources = mrArray[i];
                if (messageResources.getKey() != null) continue;
                return;
            }
            StrutsApp.addSetProperty(controller, "isMissingDefaultMessages", "true");
        }
    }

    protected static void addSetProperty(ControllerDocument.Controller controller, String propName, String propValue) {
        controller.setClassName(PAGEFLOW_CONTROLLER_CONFIG_CLASSNAME);
        SetPropertyDocument.SetProperty prop = controller.addNewSetProperty();
        prop.setProperty(propName);
        prop.setValue(propValue);
    }

    protected void writeValidatorInit(StrutsConfigDocument.StrutsConfig scElement) {
        if (this._validationModel != null && !this._validationModel.isEmpty()) {
            PlugInDocument.PlugIn plugInElementToEdit = null;
            PlugInDocument.PlugIn[] existingPlugIns = scElement.getPlugInArray();
            for (int i = 0; i < existingPlugIns.length; ++i) {
                PlugInDocument.PlugIn existingPlugIn = existingPlugIns[i];
                if (!VALIDATOR_PLUG_IN_CLASSNAME.equals(existingPlugIn.getClassName())) continue;
                plugInElementToEdit = existingPlugIn;
                break;
            }
            if (plugInElementToEdit == null) {
                plugInElementToEdit = scElement.addNewPlugIn();
                plugInElementToEdit.setClassName(VALIDATOR_PLUG_IN_CLASSNAME);
            }
            SetPropertyDocument.SetProperty[] existingSetProperties = plugInElementToEdit.getSetPropertyArray();
            for (int i = 0; i < existingSetProperties.length; ++i) {
                if (!VALIDATOR_PATHNAMES_PROPERTY.equals(existingSetProperties[i].getProperty())) continue;
                return;
            }
            SetPropertyDocument.SetProperty pathnamesProperty = plugInElementToEdit.addNewSetProperty();
            pathnamesProperty.setProperty(VALIDATOR_PATHNAMES_PROPERTY);
            StringBuilder pathNames = new StringBuilder();
            pathNames.append(NETUI_VALIDATOR_RULES_URI).append(',');
            pathNames.append(STRUTS_VALIDATOR_RULES_URI).append(',');
            pathNames.append(this._validationModel.getOutputFileURI());
            pathnamesProperty.setValue(pathNames.toString());
        }
    }

    protected void writeTilesInit(StrutsConfigDocument.StrutsConfig scElement) {
        if (this._tilesDefinitionsConfigs == null || this._tilesDefinitionsConfigs.isEmpty()) {
            return;
        }
        PlugInDocument.PlugIn plugInElementToEdit = null;
        PlugInDocument.PlugIn[] existingPlugIns = scElement.getPlugInArray();
        for (int i = 0; i < existingPlugIns.length; ++i) {
            PlugInDocument.PlugIn existingPlugIn = existingPlugIns[i];
            if (!TILES_PLUG_IN_CLASSNAME.equals(existingPlugIn.getClassName())) continue;
            plugInElementToEdit = existingPlugIn;
            break;
        }
        if (plugInElementToEdit == null) {
            plugInElementToEdit = scElement.addNewPlugIn();
            plugInElementToEdit.setClassName(TILES_PLUG_IN_CLASSNAME);
        }
        boolean definitionsConfigIsSet = false;
        boolean moduleAwarePropertyIsSet = false;
        SetPropertyDocument.SetProperty[] existingSetProperties = plugInElementToEdit.getSetPropertyArray();
        for (int i = 0; i < existingSetProperties.length; ++i) {
            String name = existingSetProperties[i].getProperty();
            if (TILES_DEFINITIONS_CONFIG_PROPERTY.equals(name)) {
                definitionsConfigIsSet = true;
            }
            if (!TILES_MODULE_AWARE_PROPERTY.equals(name)) continue;
            moduleAwarePropertyIsSet = true;
        }
        if (!definitionsConfigIsSet) {
            SetPropertyDocument.SetProperty pathnamesProperty = plugInElementToEdit.addNewSetProperty();
            pathnamesProperty.setProperty(TILES_DEFINITIONS_CONFIG_PROPERTY);
            StringBuilder pathNames = new StringBuilder();
            boolean firstOne = true;
            for (String definitionsConfig : this._tilesDefinitionsConfigs) {
                if (!firstOne) {
                    pathNames.append(',');
                }
                firstOne = false;
                pathNames.append(definitionsConfig);
            }
            pathnamesProperty.setValue(pathNames.toString());
        }
        if (!moduleAwarePropertyIsSet) {
            SetPropertyDocument.SetProperty pathnamesProperty = plugInElementToEdit.addNewSetProperty();
            pathnamesProperty.setProperty(TILES_MODULE_AWARE_PROPERTY);
            pathnamesProperty.setValue("true");
        }
    }

    protected String getHeaderComment(File mergeFile) {
        return null;
    }

    public void setNestedPageFlow(boolean nestedPageFlow) {
        this._isNestedPageFlow = nestedPageFlow;
    }

    public void setLongLivedPageFlow(boolean longLivedPageFlow) {
        this._isLongLivedPageFlow = longLivedPageFlow;
    }

    protected static String getStrutsConfigURI(String containingPackage, boolean isSharedFlow) {
        return StrutsApp.getOutputFileURI(STRUTS_CONFIG_PREFIX, containingPackage, isSharedFlow);
    }

    public static String getOutputFileURI(String filePrefix, String containingPackage, boolean isSharedFlow) {
        StringBuilder fileName = new StringBuilder(STRUTSCONFIG_OUTPUT_DIR);
        fileName.append('/').append(filePrefix);
        if (containingPackage != null && containingPackage.length() > 0) {
            fileName.append('-');
        }
        if (isSharedFlow) {
            fileName.append('-');
        }
        if (containingPackage != null) {
            fileName.append(containingPackage.replace('.', '-'));
        }
        fileName.append(STRUTS_CONFIG_EXTENSION);
        return fileName.toString();
    }

    protected void setSharedFlow(boolean sharedFlow) {
        this._isSharedFlow = sharedFlow;
    }

    protected void setSharedFlows(Map<String, String> sharedFlows) {
        this._sharedFlows = sharedFlows;
    }

    public String getMultipartHandlerClassName() {
        return this._multipartHandlerClassName;
    }

    protected void setMultipartHandlerClassName(String multipartHandlerClassName) {
        this._multipartHandlerClassName = multipartHandlerClassName;
    }

    public void setTilesDefinitionsConfigs(List<String> tilesDefinitionsConfigs) {
        this._tilesDefinitionsConfigs = tilesDefinitionsConfigs;
    }

    protected static class ActionMappingComparator
    implements Comparator {
        protected ActionMappingComparator() {
        }

        public int compare(Object o1, Object o2) {
            assert (o1 instanceof ActionModel && o2 instanceof ActionModel);
            ActionModel am1 = (ActionModel)o1;
            ActionModel am2 = (ActionModel)o2;
            assert (!am1.getPath().equals(am2.getPath()));
            return am1.getPath().compareTo(am2.getPath());
        }
    }
}

