/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.beehive.netui.compiler.model.ActionOutputModel;
import org.apache.beehive.netui.compiler.model.StrutsApp;
import org.apache.beehive.netui.compiler.model.StrutsElementSupport;
import org.apache.beehive.netui.compiler.model.schema.struts11.ForwardDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.SetPropertyDocument;

public class ForwardModel
extends StrutsElementSupport {
    private static final String JPF_ACTION_FWD_CLASSNAME = "org.apache.beehive.netui.pageflow.config.PageFlowActionForward";
    private boolean _isNestedReturn = false;
    private boolean _contextRelative = false;
    private String _name;
    private String _path;
    private boolean _redirect = false;
    private boolean _externalRedirect = false;
    private boolean _returnToPage = false;
    private boolean _returnToAction = false;
    private String _returnFormType;
    private String _returnFormMember;
    private boolean _hasExplicitRedirectValue = false;
    private List _actionOutputs = null;
    private boolean _restoreQueryString = false;

    protected ForwardModel(StrutsApp parent) {
        super(parent);
    }

    public ForwardModel(String name, String path, StrutsApp parent) {
        super(parent);
        this._name = name;
        this._path = path;
    }

    public void writeToXMLBean(ForwardDocument.Forward xb) {
        SetPropertyDocument.SetProperty prop;
        assert (this._name != null);
        xb.setName(this._name);
        if (xb.getPath() == null) {
            xb.setPath(this._path == null ? "" : this._path);
        }
        if (xb.getContextRelative() == null && this._contextRelative) {
            xb.setContextRelative(ForwardDocument.Forward.ContextRelative.TRUE);
        }
        if (xb.getRedirect() == null && this._redirect) {
            xb.setRedirect(ForwardDocument.Forward.Redirect.TRUE);
        }
        if (this._externalRedirect) {
            prop = xb.addNewSetProperty();
            prop.setProperty("externalRedirect");
            prop.setValue("true");
            xb.setClassName(JPF_ACTION_FWD_CLASSNAME);
        }
        if (this._returnToPage) {
            prop = xb.addNewSetProperty();
            prop.setProperty("returnToPage");
            prop.setValue("true");
            xb.setClassName(JPF_ACTION_FWD_CLASSNAME);
        }
        if (this._returnToAction) {
            prop = xb.addNewSetProperty();
            prop.setProperty("returnToAction");
            prop.setValue("true");
            xb.setClassName(JPF_ACTION_FWD_CLASSNAME);
        }
        if (this._hasExplicitRedirectValue) {
            prop = xb.addNewSetProperty();
            prop.setProperty("hasExplicitRedirectValue");
            prop.setValue("true");
            xb.setClassName(JPF_ACTION_FWD_CLASSNAME);
        }
        if (this._restoreQueryString) {
            prop = xb.addNewSetProperty();
            prop.setProperty("restoreQueryString");
            prop.setValue("true");
            xb.setClassName(JPF_ACTION_FWD_CLASSNAME);
        }
        if (this._actionOutputs != null && this._actionOutputs.size() > 0) {
            xb.setClassName(JPF_ACTION_FWD_CLASSNAME);
            int n = this._actionOutputs.size();
            SetPropertyDocument.SetProperty countProp = xb.addNewSetProperty();
            countProp.setProperty("actionOutputCount");
            countProp.setValue(new Integer(n).toString());
            for (int i = 0; i < n; ++i) {
                ActionOutputModel pi = (ActionOutputModel)this._actionOutputs.get(i);
                SetPropertyDocument.SetProperty prop2 = xb.addNewSetProperty();
                prop2.setProperty("actionOutput" + i);
                prop2.setValue(pi.getType() + "|" + pi.getNullable() + "|" + pi.getName());
            }
        }
        if (this._isNestedReturn) {
            SetPropertyDocument.SetProperty prop3 = xb.addNewSetProperty();
            prop3.setProperty("nestedReturn");
            prop3.setValue("true");
            if (this._returnFormType != null) {
                prop3 = xb.addNewSetProperty();
                prop3.setProperty("returnFormType");
                prop3.setValue(this._returnFormType);
            }
            if (this._returnFormMember != null) {
                prop3 = xb.addNewSetProperty();
                prop3.setProperty("returnFormMember");
                prop3.setValue(this._returnFormMember);
            }
            xb.setClassName(JPF_ACTION_FWD_CLASSNAME);
        }
        this.addComment(xb);
    }

    public boolean isReturnToPage() {
        return this._returnToPage;
    }

    public void setReturnToPage(boolean returnToPage) {
        this._returnToPage = returnToPage;
    }

    public boolean isReturnToAction() {
        return this._returnToAction;
    }

    public void setReturnToAction(boolean returnToAction) {
        this._returnToAction = returnToAction;
    }

    public void setIsNestedReturn(boolean nestedReturn) {
        this._isNestedReturn = nestedReturn;
    }

    public String getReturnFormType() {
        return this._returnFormType;
    }

    public void setReturnFormType(String returnFormType) {
        this._returnFormType = returnFormType;
    }

    public String getReturnFormMember() {
        return this._returnFormMember;
    }

    public void setReturnFormMember(String returnFormMember) {
        this._returnFormMember = returnFormMember;
    }

    public boolean getContextRelative() {
        return this._contextRelative;
    }

    public void setContextRelative(boolean contextRelative) {
        this._contextRelative = contextRelative;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public boolean isRedirect() {
        return this._redirect;
    }

    public void setRedirect(boolean redirect) {
        this._redirect = redirect;
        this._hasExplicitRedirectValue = redirect;
    }

    public boolean isExternalRedirect() {
        return this._externalRedirect;
    }

    public void setExternalRedirect(boolean externalRedirect) {
        this._externalRedirect = externalRedirect;
        this.setRedirect(externalRedirect);
    }

    public boolean isRestoreQueryString() {
        return this._restoreQueryString;
    }

    public void setRestoreQueryString(boolean restore) {
        this._restoreQueryString = restore;
    }

    public final boolean isPageForward() {
        return this.forwardsToPage();
    }

    public boolean forwardsToPage() {
        return !this._path.endsWith(".do") && !this._path.endsWith(".jpf");
    }

    public boolean forwardsToAction() {
        return this._path.endsWith(".do");
    }

    public final boolean forwardsToPageFlow() {
        return this._path.endsWith(".jpf");
    }

    public String getPageName() {
        assert (this.forwardsToPage()) : "getPageName() called for non-page " + this._path;
        int slash = this._path.lastIndexOf(47);
        return slash != -1 ? this._path.substring(slash + 1) : this._path;
    }

    public String getActionName() {
        assert (this.forwardsToAction()) : "getActionName() called for non-action" + this._path;
        int index = this._path.indexOf(".do");
        assert (index != -1);
        return this._path.substring(0, index);
    }

    public void addActionOutput(ActionOutputModel actionOutput) {
        if (this._actionOutputs == null) {
            this._actionOutputs = new ArrayList();
        }
        this._actionOutputs.add(actionOutput);
    }

    public void setActionOutputs(List actionOutputs) {
        this._actionOutputs = actionOutputs;
    }

    public boolean isNestedReturn() {
        return this._isNestedReturn;
    }
}

