/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beehive.netui.compiler.model.StrutsApp;
import org.apache.beehive.netui.compiler.model.StrutsElementSupport;
import org.apache.beehive.netui.compiler.model.schema.struts11.FormBeanDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.SetPropertyDocument;

public class FormBeanModel
extends StrutsElementSupport {
    private static final String JPF_ACTION_FORM_BEAN_CLASSNAME = "org.apache.beehive.netui.pageflow.config.PageFlowActionFormBean";
    private String _id = "";
    private String _className = null;
    private boolean _dynamic = false;
    private String _name = null;
    private String _type = null;
    private String _actualType = null;
    private ArrayList _properties = new ArrayList();

    public FormBeanModel(String name, String type, String actualType, StrutsApp parent) {
        super(parent);
        this._name = name;
        this._type = type;
        this._actualType = actualType;
    }

    public void writeToXMLBean(FormBeanDocument.FormBean xb) {
        xb.setName(this._name);
        if (xb.getType() == null) {
            xb.setType(this._type);
        }
        if (xb.getId() == null && this._id != null && this._id.length() > 0) {
            xb.setId(this._id);
        }
        if (this._actualType != null) {
            SetPropertyDocument.SetProperty prop = xb.addNewSetProperty();
            prop.setProperty("actualType");
            prop.setValue(this._actualType);
            xb.setClassName(JPF_ACTION_FORM_BEAN_CLASSNAME);
        }
        if (xb.getClassName() == null && this._className != null) {
            xb.setClassName(this._className);
        }
        if (xb.getDynamic() == null && this._dynamic) {
            xb.setDynamic(FormBeanDocument.FormBean.Dynamic.TRUE);
        }
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        if (className != null) {
            if ("org.apache.struts.action.DynaActionForm".equals(className)) {
                this._dynamic = true;
            }
            this._className = className;
        }
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this._dynamic = dynamic;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getActualType() {
        return this._actualType;
    }

    public void setActualType(String actualType) {
        this._actualType = actualType;
    }

    public void addProperty(String name, String type, boolean required, boolean multival) {
        this._properties.add(new Property(name, type, required, multival));
    }

    public void updateProperties(Collection newProps) {
        this._properties = new ArrayList();
        if (newProps != null) {
            this._properties.addAll(newProps);
        }
    }

    public Property[] getProperties() {
        return this._properties.toArray(new Property[0]);
    }

    public void deleteProperty(String name) {
        for (int i = 0; i < this._properties.size(); ++i) {
            Property prop = (Property)this._properties.get(i);
            if (!prop.getName().equals(name)) continue;
            this._properties.remove(i--);
        }
    }

    public void deleteProperty(Property prop) {
        this._properties.remove(prop);
    }

    public Property findProperty(String name) {
        int index = this.findPropertyIndex(name);
        return index != -1 ? (Property)this._properties.get(index) : null;
    }

    protected int findPropertyIndex(String name) {
        for (int i = 0; i < this._properties.size(); ++i) {
            Property prop = (Property)this._properties.get(i);
            if (!prop.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected final List getPropertyList() {
        return (List)this._properties.clone();
    }

    public static class Property {
        String name;
        String type;
        boolean required;
        boolean multiValue;

        public Property(String name, String type, boolean required, boolean multival) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.multiValue = multival;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean isMultiValue() {
            return this.multiValue;
        }

        public void setMultiValue(boolean multi) {
            this.multiValue = multi;
        }
    }
}

