/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beehive.netui.compiler.model.AbstractForwardContainer;
import org.apache.beehive.netui.compiler.model.ExceptionContainer;
import org.apache.beehive.netui.compiler.model.ExceptionModel;
import org.apache.beehive.netui.compiler.model.ForwardContainer;
import org.apache.beehive.netui.compiler.model.StrutsApp;
import org.apache.beehive.netui.compiler.model.schema.struts11.ActionDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.ExceptionDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.ForwardDocument;
import org.apache.beehive.netui.compiler.model.schema.struts11.SetPropertyDocument;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionModel
extends AbstractForwardContainer
implements ForwardContainer,
ExceptionContainer {
    public static final String DEFAULT_FORM_SCOPE = "request";
    private static final String JPF_ACTION_MAPPING_CLASSNAME = "org.apache.beehive.netui.pageflow.config.PageFlowActionMapping";
    private ArrayList _exceptionCatches = new ArrayList();
    private String _attribute;
    private String _className;
    private String _forward;
    private String _include;
    private String _input;
    private String _formBeanName;
    private String _parameter;
    private String _path;
    private String _prefix;
    private String _scope = "request";
    private String _suffix;
    private String _type;
    private boolean _unknown;
    private String _roles;
    private boolean _validate;
    private String _unqualifiedActionPath;
    private boolean _loginRequired;
    private boolean _isOverloaded;
    private boolean _readonly;
    private boolean _isSimpleAction = false;
    private boolean _preventDoubleSubmit = false;
    private String _formMember;
    private String _formClass;
    private Map<String, String> _conditionalForwards;
    private String _formBeanMessageResourcesKey;
    private String _defaultForwardName;

    public ActionModel(String path, StrutsApp parent) {
        this(path, null, parent);
    }

    public ActionModel(String path, String formName, StrutsApp parent) {
        super(parent);
        this._path = path;
        this._formBeanName = formName;
    }

    protected ActionModel(StrutsApp parent) {
        this(null, null, parent);
    }

    public ActionModel(ActionModel src, String newPath) {
        super(src);
        this._path = newPath;
        this._formBeanName = src._formBeanName;
        this._exceptionCatches = (ArrayList)src._exceptionCatches.clone();
        this._attribute = src._attribute;
        this._className = src._className;
        this._forward = src._forward;
        this._include = src._include;
        this._input = src._input;
        this._validate = src._validate;
        this._parameter = src._parameter;
        this._prefix = src._prefix;
        this._scope = src._scope;
        this._suffix = src._suffix;
        this._type = src._type;
        this._unknown = src._unknown;
        this._formMember = src._formMember;
        this._formClass = src._formClass;
        this._roles = src._roles;
        this._loginRequired = src._loginRequired;
        this._preventDoubleSubmit = src._preventDoubleSubmit;
        this._isSimpleAction = src._isSimpleAction;
        this._isOverloaded = src._isOverloaded;
        this._readonly = src._readonly;
        this._unqualifiedActionPath = src._unqualifiedActionPath;
        this._defaultForwardName = src._defaultForwardName;
    }

    public void setFormBeanName(String formBeanName) {
        this._formBeanName = formBeanName;
    }

    public void writeToXMLBean(ActionDocument.Action xb) {
        xb.setPath(this._path);
        if (xb.getName() == null && this._formBeanName != null) {
            xb.setName(this._formBeanName);
        }
        if (xb.getClassName() == null && this._className != null) {
            xb.setClassName(this._className);
        }
        if (xb.getType() == null && this._type != null) {
            xb.setType(this._type);
        }
        if (xb.getAttribute() == null && this._attribute != null) {
            xb.setAttribute(this._attribute);
        }
        if (xb.getInput() == null && this._input != null) {
            xb.setInput(this._input);
        }
        if (xb.getParameter() == null && this._parameter != null) {
            xb.setParameter(this._parameter);
        }
        if (xb.getPrefix() == null && this._prefix != null) {
            xb.setPrefix(this._prefix);
        }
        if (xb.getSuffix() == null && this._suffix != null) {
            xb.setSuffix(this._suffix);
        }
        if (xb.getScope() == null) {
            if (this._scope != null) {
                if (this._scope.equals(DEFAULT_FORM_SCOPE)) {
                    xb.setScope(ActionDocument.Action.Scope.REQUEST);
                } else if (this._scope.equals("session")) {
                    xb.setScope(ActionDocument.Action.Scope.SESSION);
                } else assert (false) : this._scope;
            } else {
                xb.setScope(ActionDocument.Action.Scope.REQUEST);
            }
        }
        if (xb.getRoles() == null && this._roles != null) {
            xb.setRoles(this._roles);
        }
        if (xb.getForward2() == null && this._forward != null) {
            xb.setForward2(this._forward);
        }
        if (xb.getInclude() == null && this._include != null) {
            xb.setInclude(this._include);
        }
        if (xb.getUnknown() == null && this._unknown) {
            xb.setUnknown(ActionDocument.Action.Unknown.TRUE);
        }
        if (xb.getValidate() == null) {
            xb.setValidate(this._validate ? ActionDocument.Action.Validate.TRUE : ActionDocument.Action.Validate.FALSE);
        }
        if (this._unqualifiedActionPath != null) {
            this.addSetProperty(xb, "unqualifiedActionPath", this._unqualifiedActionPath);
        }
        if (this._formMember != null) {
            this.addSetProperty(xb, "formMember", this._formMember);
        }
        if (this._formClass != null) {
            this.addSetProperty(xb, "formClass", this._formClass);
        }
        if (this._loginRequired) {
            this.addSetProperty(xb, "loginRequired", this._loginRequired);
        }
        if (this._preventDoubleSubmit) {
            this.addSetProperty(xb, "preventDoubleSubmit", this._preventDoubleSubmit);
        }
        if (this._isOverloaded) {
            this.addSetProperty(xb, "overloaded", this._isOverloaded);
        }
        if (this._readonly) {
            this.addSetProperty(xb, "readonly", this._readonly);
        }
        if (this._isSimpleAction) {
            this.addSetProperty(xb, "simpleAction", this._isSimpleAction);
        }
        if (this._defaultForwardName != null) {
            this.addSetProperty(xb, "defaultForward", this._defaultForwardName);
        }
        if (this._conditionalForwards != null) {
            this.addSetProperty(xb, "conditionalForwards", ActionModel.getMapString(this._conditionalForwards));
        }
        if (this._formBeanMessageResourcesKey != null) {
            this.addSetProperty(xb, "formBeanMessageResourcesKey", this._formBeanMessageResourcesKey);
        }
        if (this._exceptionCatches != null && !this._exceptionCatches.isEmpty()) {
            ExceptionDocument.Exception[] existingExceptions = xb.getExceptionArray();
            for (int i = 0; i < this._exceptionCatches.size(); ++i) {
                ExceptionModel ec = (ExceptionModel)this._exceptionCatches.get(i);
                ExceptionDocument.Exception exceptionToEdit = null;
                for (int j = 0; j < existingExceptions.length; ++j) {
                    if (!ec.getType().equals(existingExceptions[j].getType())) continue;
                    exceptionToEdit = existingExceptions[j];
                    break;
                }
                if (exceptionToEdit == null) {
                    exceptionToEdit = xb.addNewException();
                }
                ec.writeToXMLBean(exceptionToEdit);
            }
        }
        this.writeForwards(xb.getForwardArray(), xb);
        this.addComment(xb);
    }

    private void addSetProperty(ActionDocument.Action xb, String propertyName, boolean propertyValue) {
        this.addSetProperty(xb, propertyName, Boolean.toString(propertyValue));
    }

    private void addSetProperty(ActionDocument.Action xb, String propertyName, String propertyValue) {
        SetPropertyDocument.SetProperty prop = xb.addNewSetProperty();
        prop.setProperty(propertyName);
        prop.setValue(propertyValue);
        xb.setClassName(JPF_ACTION_MAPPING_CLASSNAME);
    }

    @Override
    protected ForwardDocument.Forward addNewForward(XmlObject xmlObject) {
        return ((ActionDocument.Action)xmlObject).addNewForward();
    }

    @Override
    public void addException(ExceptionModel em) {
        this._exceptionCatches.add(em);
    }

    public String getAttribute() {
        return this._attribute;
    }

    public void setAttribute(String attribute) {
        this._attribute = attribute;
    }

    @Override
    public String getClassName() {
        return this._className;
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    public String getForward() {
        return this._forward;
    }

    public void setForward(String forward) {
        this._forward = forward;
    }

    public String getInclude() {
        return this._include;
    }

    public void setInclude(String include) {
        this._include = include;
    }

    public String getInput() {
        return this._input;
    }

    public void setInput(String input) {
        this._input = input;
    }

    public String getName() {
        return this._formBeanName;
    }

    public String getFormBeanName() {
        return this._formBeanName;
    }

    public void setName(String name) {
        this._formBeanName = name;
    }

    public String getParameter() {
        return this._parameter;
    }

    public void setParameter(String parameter) {
        this._parameter = parameter;
    }

    public boolean isValidate() {
        return this._validate;
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    public String getPath() {
        return this._path;
    }

    public String getPath(boolean useUnqualifiedPath) {
        if (useUnqualifiedPath && this._unqualifiedActionPath != null) {
            return this._unqualifiedActionPath;
        }
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public String getScope() {
        return this._scope == null ? DEFAULT_FORM_SCOPE : this._scope;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public void setSuffix(String suffix) {
        this._suffix = suffix;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public boolean isUnknown() {
        return this._unknown;
    }

    public void setUnknown(boolean unknown) {
        this._unknown = unknown;
    }

    public String getUnqualifiedActionPath() {
        return this._unqualifiedActionPath;
    }

    public void setUnqualifiedActionPath(String unqualifiedActionPath) {
        this._unqualifiedActionPath = unqualifiedActionPath;
    }

    public String getDefaultForwardName() {
        return this._defaultForwardName;
    }

    public void setDefaultForwardName(String defaultForwardName) {
        this._defaultForwardName = defaultForwardName;
    }

    public String getRoles() {
        return this._roles;
    }

    public void setRoles(String roles) {
        this._roles = roles;
    }

    public void setLoginRequired(boolean loginRequired) {
        this._loginRequired = loginRequired;
    }

    public void setPreventDoubleSubmit(boolean preventDoubleSubmit) {
        this._preventDoubleSubmit = preventDoubleSubmit;
    }

    public boolean isSimpleAction() {
        return this._isSimpleAction;
    }

    public void setSimpleAction(boolean simpleAction) {
        this._isSimpleAction = simpleAction;
    }

    public boolean isOverloaded() {
        return this._isOverloaded;
    }

    public void setOverloaded(boolean overloaded) {
        this._isOverloaded = overloaded;
    }

    public String getFormMember() {
        return this._formMember;
    }

    public void setFormMember(String formMember) {
        this._formMember = formMember;
    }

    public String getFormClass() {
        return this._formClass;
    }

    public void setFormClass(String formClass) {
        this._formClass = formClass;
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        this._readonly = readonly;
    }

    public void addConditionalForward(String expression, String forwardName) {
        if (this._conditionalForwards == null) {
            this._conditionalForwards = new LinkedHashMap<String, String>();
        }
        this._conditionalForwards.put(expression, forwardName);
    }

    private static String getMapString(Map<String, String> map) {
        StringBuilder retVal = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            retVal.append(entry.getValue()).append(":").append(entry.getKey()).append(";");
        }
        return retVal.toString();
    }

    public void setFormBeanMessageResourcesKey(String formBeanMessageResourcesKey) {
        this._formBeanMessageResourcesKey = formBeanMessageResourcesKey;
    }
}

