/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.beehive.netui.compiler.model.StrutsApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappPathType
extends AnnotationMemberType {
    private static final String[] CHECKABLE_EXTENSIONS = new String[]{"jsp", "jspx", "jpf", "htm", "html"};
    private boolean _pathMustBeRelative = false;
    private FlowControllerInfo _flowControllerInfo;

    public WebappPathType(boolean pathMustBeRelative, String requiredRuntimeVersion, AnnotationGrammar parentGrammar, FlowControllerInfo fcInfo) {
        super(requiredRuntimeVersion, parentGrammar);
        this._pathMustBeRelative = pathMustBeRelative;
        this._flowControllerInfo = fcInfo;
    }

    @Override
    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        String filePath = (String)value.getValue();
        try {
            URI uri = new URI(filePath);
            filePath = uri.getPath();
        }
        catch (URISyntaxException e) {
            this.addError(value, "error.invalid-uri", e.getLocalizedMessage());
            return null;
        }
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        if (!this.checkAnyExtension()) {
            boolean isCheckableExtension = false;
            for (int i = 0; i < CHECKABLE_EXTENSIONS.length; ++i) {
                if (!filePath.endsWith(CHECKABLE_EXTENSIONS[i])) continue;
                isCheckableExtension = true;
                break;
            }
            if (!isCheckableExtension) {
                return null;
            }
        }
        boolean fileExists = true;
        File jpfFile = CompilerUtils.getOriginalFile(CompilerUtils.getOuterClass(classMember));
        TypeDeclaration outerClass = CompilerUtils.getOutermostClass(classMember);
        File fileToCheck = null;
        if (filePath.charAt(0) == '/') {
            File webappRoot;
            if (this._pathMustBeRelative) {
                this.addError(value, "error.relative-uri", new Object[0]);
            }
            if (filePath.endsWith(".jpf")) {
                TypeDeclaration type = CompilerUtils.inferTypeFromPath(filePath, this.getEnv());
                File file = fileToCheck = type != null ? CompilerUtils.getOriginalFile(type) : null;
            }
            if (!(fileToCheck != null || (fileToCheck = new File((webappRoot = WebappPathType.getWebFilesRoot(jpfFile, true, this.getEnv())) + filePath)).exists() || this.ignoreDirectories() && fileToCheck.isDirectory())) {
                fileExists = false;
            }
        } else if (jpfFile != null && filePath.indexOf(47) != 0 && !CompilerUtils.hasModifier((Declaration)outerClass, Modifier.ABSTRACT)) {
            CompilerUtils.Mutable<File> retFileToCheck = new CompilerUtils.Mutable<File>();
            fileExists = WebappPathType.checkRelativePath(filePath, outerClass, jpfFile, retFileToCheck, this.ignoreDirectories(), this.mustBeInPageFlowDir(), this.getEnv());
            fileToCheck = retFileToCheck.get();
        }
        if (fileExists) {
            if (fileToCheck != null) {
                this.runAdditionalChecks(fileToCheck, value);
            }
        } else if (this.doFatalError()) {
            this.addError(value, "error.file-not-found", filePath);
        } else {
            this.addWarning(value, "warning.file-not-found", filePath);
        }
        if (fileToCheck != null) {
            this._flowControllerInfo.addReferencedFile(fileToCheck);
        }
        return null;
    }

    public static boolean relativePathExists(String filePath, TypeDeclaration outerClass, AnnotationProcessorEnvironment env) {
        File jpfFile = CompilerUtils.getOriginalFile(CompilerUtils.getOuterClass((MemberDeclaration)outerClass));
        return WebappPathType.checkRelativePath(filePath, outerClass, jpfFile, null, true, false, env);
    }

    private static boolean checkRelativePath(String filePath, TypeDeclaration outerClass, File jpfFile, CompilerUtils.Mutable<File> retFileToCheck, boolean ignoreDirectories, boolean mustBeInPageFlowDir, AnnotationProcessorEnvironment env) {
        File fileToCheck;
        boolean fileExists = true;
        if (filePath.endsWith(".jpf")) {
            String className = filePath.substring(0, filePath.length() - ".jpf".length());
            String pkg = outerClass.getPackage().getQualifiedName();
            while (className.startsWith("../") && className.length() > 3) {
                className = className.substring(3);
                int lastDot = pkg.lastIndexOf(46);
                pkg = lastDot != -1 ? pkg.substring(0, lastDot) : "";
            }
            className = (pkg.length() > 0 ? pkg + '.' : "") + className.replace('/', '.');
            TypeDeclaration type = env.getTypeDeclaration(className);
            File file = fileToCheck = type != null ? CompilerUtils.getOriginalFile(type) : null;
            if (fileToCheck == null) {
                fileExists = false;
            }
        } else {
            File desiredParentDir;
            File webappRoot = WebappPathType.getWebFilesRoot(jpfFile, false, env);
            File webFilesRoot = WebappPathType.getWebFilesRoot(jpfFile, true, env);
            File jpfParent = jpfFile.getAbsoluteFile().getParentFile();
            assert (jpfParent.getPath().startsWith(webappRoot.getPath())) : jpfParent.getPath();
            String jpfParentRelativePath = jpfParent.getPath().substring(webappRoot.getPath().length());
            if (!mustBeInPageFlowDir && (jpfParentRelativePath = jpfParentRelativePath.replace('\\', '/')).startsWith("/WEB-INF/src")) {
                jpfParentRelativePath = jpfParentRelativePath.substring("/WEB-INF/src".length());
            }
            if (!((fileToCheck = new File(desiredParentDir = new File(webFilesRoot + jpfParentRelativePath), filePath)).exists() || ignoreDirectories && fileToCheck.isDirectory())) {
                fileExists = false;
            }
        }
        if (retFileToCheck != null) {
            retFileToCheck.set(fileToCheck);
        }
        return fileExists;
    }

    protected static File getWebFilesRoot(File jpfFile, boolean useAlternateLocation, AnnotationProcessorEnvironment env) {
        try {
            String alternateRoot = null;
            if (useAlternateLocation && (alternateRoot = (String)env.getOptions().get("-AalternateWebRootDir")) == null) {
                for (String i : env.getOptions().keySet()) {
                    String key = i;
                    if (!key.startsWith("-AalternateWebRootDir=")) continue;
                    alternateRoot = key.substring("-AalternateWebRootDir".length() + 1);
                    break;
                }
            }
            return alternateRoot != null ? new File(alternateRoot) : StrutsApp.getWebappRootFromJpf(jpfFile);
        }
        catch (NoWebInfDirectoryException e) {
            assert (false) : e;
            return null;
        }
    }

    protected boolean checkAnyExtension() {
        return false;
    }

    protected boolean doFatalError() {
        return false;
    }

    protected void runAdditionalChecks(File file, AnnotationValue member) {
    }

    protected boolean ignoreDirectories() {
        return true;
    }

    protected boolean mustBeInPageFlowDir() {
        return false;
    }

    protected FlowControllerInfo getFlowControllerInfo() {
        return this._flowControllerInfo;
    }
}

