/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import java.util.Collection;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.MergedControllerAnnotation;
import org.apache.beehive.netui.compiler.grammar.WebappPathType;

public class WebappPathOrActionType
extends WebappPathType {
    public WebappPathOrActionType(boolean pathMustBeRelative, String requiredRuntimeVersion, AnnotationGrammar parentGrammar, FlowControllerInfo fcInfo) {
        super(pathMustBeRelative, requiredRuntimeVersion, parentGrammar, fcInfo);
    }

    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        TypeDeclaration outerType;
        String stringValue = (String)value.getValue();
        if (stringValue.endsWith(".do") && stringValue.indexOf(47) == -1 && (outerType = CompilerUtils.getOuterClass(classMember)) != null) {
            TypeDeclaration globalAppDecl;
            int dot;
            int extensionPos = stringValue.lastIndexOf(".do");
            String actionMethodName = stringValue.substring(0, extensionPos);
            FlowControllerInfo fcInfo = this.getFlowControllerInfo();
            boolean foundIt = WebappPathOrActionType.actionExists(actionMethodName, outerType, null, this.getEnv(), fcInfo, false);
            if (!foundIt && (dot = actionMethodName.indexOf(46)) != 1 && dot > actionMethodName.length() - 1) {
                String sharedFlowName = actionMethodName.substring(0, dot);
                TypeDeclaration sfTypeDecl = this.getFlowControllerInfo().getSharedFlowTypes().get(sharedFlowName);
                if (sfTypeDecl != null) {
                    actionMethodName = actionMethodName.substring(dot + 1);
                    foundIt = WebappPathOrActionType.actionExists(actionMethodName, sfTypeDecl, null, this.getEnv(), fcInfo, false);
                }
            }
            if (!foundIt && (globalAppDecl = this.getEnv().getTypeDeclaration("global.Global")) != null) {
                foundIt = WebappPathOrActionType.actionExists(actionMethodName, globalAppDecl, null, this.getEnv(), fcInfo, false);
            }
            if (!foundIt) {
                this.addWarning(value, "warning.action-not-found", actionMethodName);
            }
        }
        return super.onCheck(valueDecl, value, parentAnnotations, classMember);
    }

    public static boolean actionExists(String actionName, TypeDeclaration type, AnnotationMirror annotationToIgnore, AnnotationProcessorEnvironment env, FlowControllerInfo fcInfo, boolean checkInheritedActions) {
        Collection<AnnotationMirror> simpleActionAnnotations;
        ClassType superType;
        if (!(type instanceof ClassDeclaration)) {
            return false;
        }
        ClassDeclaration classDecl = (ClassDeclaration)type;
        do {
            Collection methods = classDecl.getMethods();
            for (MethodDeclaration method : methods) {
                if (!method.getSimpleName().equals(actionName) || CompilerUtils.getAnnotation((Declaration)method, "Action") == null) continue;
                return true;
            }
        } while ((classDecl = (superType = classDecl.getSuperclass()) != null ? superType.getDeclaration() : null) != null);
        MergedControllerAnnotation mca = fcInfo.getMergedControllerAnnotation();
        Collection<AnnotationMirror> collection = simpleActionAnnotations = checkInheritedActions ? mca.getSimpleActions() : CompilerUtils.getAnnotationArrayValue((Declaration)type, "Controller", "simpleActions", true);
        if (simpleActionAnnotations != null) {
            for (AnnotationMirror ann : simpleActionAnnotations) {
                String name = CompilerUtils.getString(ann, "name", false);
                if (!actionName.equals(name) || CompilerUtils.annotationsAreEqual(ann, annotationToIgnore, false, env)) continue;
                return true;
            }
        }
        return false;
    }
}

