/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MemberDeclaration;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.grammar.BaseValidationRuleGrammar;

public class ValidateRangeGrammar
extends BaseValidationRuleGrammar {
    private static String[][] MUTUALLY_EXCLUSIVE_ATTRS = new String[][]{{"minInt", "minFloat"}, {"maxInt", "maxFloat"}};
    private static String[][] ATTR_DEPENDENCIES = new String[][]{{"minInt", "maxInt"}, {"minFloat", "maxFloat"}, {"maxInt", "minInt"}, {"maxFloat", "minFloat"}};

    public ValidateRangeGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, RuntimeVersionChecker runtimeVersionChecker) {
        super(env, diags, runtimeVersionChecker);
        this.addMemberType("minFloat", new FloatType());
        this.addMemberType("maxFloat", new FloatType());
    }

    public String[][] getMutuallyExclusiveAttrs() {
        return MUTUALLY_EXCLUSIVE_ATTRS;
    }

    public String[][] getRequiredAttrs() {
        return null;
    }

    public String[][] getAttrDependencies() {
        return ATTR_DEPENDENCIES;
    }

    private class FloatType
    extends AnnotationMemberType {
        public FloatType() {
            super(ValidateRangeGrammar.this.getRequiredRuntimeVersion(), ValidateRangeGrammar.this);
        }

        public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue member, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
            Double d = (Double)member.getValue();
            if (d < -3.4028234663852886E38) {
                this.addError(member, "error.min-float", Float.valueOf(-3.4028235E38f));
            } else if (d > 3.4028234663852886E38) {
                this.addError(member, "error.max-float", Float.valueOf(Float.MAX_VALUE));
            }
            return null;
        }
    }
}

