/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.grammar.BaseValidationRuleGrammar;
import org.apache.beehive.netui.compiler.grammar.LocaleRulesGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateCustomGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateRangeGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateTypeGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateValidWhenGrammar;

public class ValidatablePropertyGrammar
extends AnnotationGrammar {
    private static String[][] REQUIRED_ATTRS = new String[][]{{"propertyName"}};
    private static String[][] MUTUALLY_EXCLUSIVE_ATTRS = new String[][]{{"displayName", "displayNameKey"}};

    public ValidatablePropertyGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, RuntimeVersionChecker rvc) {
        super(env, diags, "3", rvc);
        this.addMemberType("propertyName", new AnnotationMemberType(null, this));
        this.addMemberType("displayName", new AnnotationMemberType(null, this));
        this.addMemberType("displayNameKey", new AnnotationMemberType(null, this));
        this.addMemberArrayGrammar("localeRules", new LocaleRulesGrammar(env, diags, rvc));
        this.addMemberGrammar("validateRequired", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateRange", new ValidateRangeGrammar(env, diags, rvc));
        this.addMemberGrammar("validateMinLength", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateMaxLength", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateCreditCard", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateEmail", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateMask", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateDate", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateType", new ValidateTypeGrammar(env, diags, rvc));
        this.addMemberGrammar("validateCustom", new ValidateCustomGrammar(env, diags, rvc));
        this.addMemberGrammar("validateValidWhen", new ValidateValidWhenGrammar(env, diags, rvc));
    }

    public String[][] getRequiredAttrs() {
        return REQUIRED_ATTRS;
    }

    public String[][] getMutuallyExclusiveAttrs() {
        return MUTUALLY_EXCLUSIVE_ATTRS;
    }

    protected boolean onBeginCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        Boolean doValidation;
        AnnotationMirror actionAnnotation = CompilerUtils.getAnnotation((Declaration)classMember, "Action");
        if (actionAnnotation != null && CompilerUtils.getAnnotationValue(actionAnnotation, "validationErrorForward", true) == null && ((doValidation = CompilerUtils.getBoolean(actionAnnotation, "doValidation", true)) == null || doValidation.booleanValue())) {
            this.addWarning(annotation, "warning.validation-annotations-no-forward", "Jpf.Action", "validationErrorForward");
        }
        return true;
    }
}

