/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.declaration.AnnotationValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.grammar.WebappPathType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class ValidXmlFileType
extends WebappPathType {
    private SchemaType _schema;
    private static Map _parseResults = Collections.synchronizedMap(new HashMap());

    public ValidXmlFileType(SchemaType schema, String requiredRuntimeVersion, AnnotationGrammar parentGrammar, FlowControllerInfo fcInfo) {
        super(false, requiredRuntimeVersion, parentGrammar, fcInfo);
        this._schema = schema;
    }

    protected boolean checkAnyExtension() {
        return true;
    }

    protected boolean doFatalError() {
        return true;
    }

    protected boolean ignoreDirectories() {
        return false;
    }

    protected boolean mustBeInPageFlowDir() {
        return true;
    }

    protected void runAdditionalChecks(File file, AnnotationValue value) {
        block10: {
            try {
                ParseResults prevResults = (ParseResults)_parseResults.get(file.getPath());
                if (prevResults == null || file.lastModified() > prevResults.getFileModTime()) {
                    try {
                        XmlOptions options = new XmlOptions();
                        options.setDocumentType(this._schema);
                        XmlObject xml = XmlObject.Factory.parse((File)file, (XmlOptions)options);
                        ArrayList errorListener = new ArrayList();
                        options.setErrorListener(errorListener);
                        if (!xml.validate(options)) {
                            assert (!errorListener.isEmpty());
                            XmlError err = (XmlError)errorListener.get(0);
                            assert (err != null);
                            throw new XmlException(err.getMessage(), null, err);
                        }
                    }
                    catch (Exception e) {
                        _parseResults.put(file.getPath(), new ParseResults(file.lastModified(), e));
                        throw e;
                    }
                    _parseResults.put(file.getPath(), new ParseResults(file.lastModified(), null));
                    break block10;
                }
                Exception e = prevResults.getException();
                if (e != null) {
                    throw e;
                }
            }
            catch (XmlException e) {
                this.addErrorDiagnostic(e.getError(), value);
            }
            catch (Exception e) {
                this.addError(value, "error.xml-read-error", file.getPath(), e.getMessage());
            }
        }
    }

    private void addErrorDiagnostic(XmlError err, AnnotationValue value) {
        if (err.getColumn() != -1 && err.getLine() != -1) {
            Object[] args = new Object[]{err.getSourceName(), new Integer(err.getLine()), new Integer(err.getColumn()), err.getMessage()};
            this.addError(value, "error.xml-parse-error", args);
        } else if (err.getLine() != -1) {
            Object[] args = new Object[]{err.getSourceName(), new Integer(err.getLine()), err.getMessage()};
            this.addError(value, "error.xml-parse-error-nocolumn", args);
        } else {
            Object[] args = new Object[]{err.getSourceName(), err.getMessage()};
            this.addError(value, "error.xml-parse-error-nolinecolumn", args);
        }
    }

    private static class ParseResults {
        private long _fileModTime;
        private Exception _exception;

        public ParseResults(long fileModTime, Exception exception) {
            this._fileModTime = fileModTime;
            this._exception = exception;
        }

        public long getFileModTime() {
            return this._fileModTime;
        }

        public void setFileModTime(long fileModTime) {
            this._fileModTime = fileModTime;
        }

        public Exception getException() {
            return this._exception;
        }

        public void setException(Exception exception) {
            this._exception = exception;
        }
    }
}

