/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.type.DeclaredType;
import java.util.Collection;
import java.util.List;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueValueType
extends AnnotationMemberType {
    private boolean _allowEmptyString;
    private boolean _checkDefaultValues;
    private String _memberGroupName;

    public UniqueValueType(String memberGroupName, boolean allowEmptyString, boolean checkDefaultValues, String requiredRuntimeVersion, AnnotationGrammar parentGrammar) {
        super(requiredRuntimeVersion, parentGrammar);
        this._allowEmptyString = allowEmptyString;
        this._memberGroupName = memberGroupName;
        this._checkDefaultValues = checkDefaultValues;
    }

    @Override
    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        String val = (String)value.getValue();
        if (!this._allowEmptyString && val.length() == 0) {
            this.addError(value, "error.empty-string-not-allowed", new Object[0]);
            return null;
        }
        if (parentAnnotations.length < 2) {
            return null;
        }
        AnnotationMirror parentElement = parentAnnotations[parentAnnotations.length - 2];
        List<AnnotationMirror> memberGroup = CompilerUtils.getAnnotationArray(parentElement, this._memberGroupName, true);
        if (memberGroup != null) {
            String valueName = valueDecl.getSimpleName();
            AnnotationMirror parentAnnotation = parentAnnotations[parentAnnotations.length - 1];
            this.checkForDuplicates(value, valueName, parentAnnotation, classMember, memberGroup, false);
            List<AnnotationMirror> additionalAnnsToCheck = this.getAdditionalAnnotationsToCheck(classMember);
            if (additionalAnnsToCheck != null) {
                this.checkForDuplicates(value, valueName, parentAnnotation, classMember, additionalAnnsToCheck, true);
                for (AnnotationMirror ann : additionalAnnsToCheck) {
                    AnnotationValue valueToCheck = CompilerUtils.getAnnotationValue(ann, valueName, true);
                    this.checkForDuplicates(valueToCheck, valueName, ann, classMember, additionalAnnsToCheck, true);
                }
            }
        }
        return null;
    }

    protected List<AnnotationMirror> getAdditionalAnnotationsToCheck(MemberDeclaration classMember) {
        return null;
    }

    protected String getErrorMessageExtraInfo() {
        return null;
    }

    protected void checkForDuplicates(AnnotationValue member, String memberName, AnnotationMirror parentAnnotation, MemberDeclaration classMember, Collection<AnnotationMirror> annotationsToCheck, boolean includeEntityInMsg) {
        Object memberValue = member.getValue();
        for (AnnotationMirror annotation : annotationsToCheck) {
            AnnotationValue valueToCheck;
            if (CompilerUtils.annotationsAreEqual(annotation, parentAnnotation, this.allowExactDuplicates(), this.getEnv()) || (valueToCheck = CompilerUtils.getAnnotationValue(annotation, memberName, this._checkDefaultValues)) == null || valueToCheck.equals(member) || !valueToCheck.getValue().equals(memberValue)) continue;
            String annotationName = CompilerUtils.getDeclaration((DeclaredType)parentAnnotation.getAnnotationType()).getSimpleName();
            if (includeEntityInMsg) {
                String extra = this.getErrorMessageExtraInfo();
                Object[] args = new Object[]{annotationName, memberName, memberValue, classMember.getSimpleName(), extra};
                this.addError(member, "error.duplicate-attr2", args);
                continue;
            }
            this.addError(member, "error.duplicate-attr", annotationName, memberName, memberValue);
        }
    }

    protected boolean allowExactDuplicates() {
        return false;
    }
}

